/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.filebuffer.CodecFileBuffer;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.codec.filebuffer.FileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.MetaDataCodec;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileHeaderStrategy
implements FileHeaderStrategy {
    private final Logger logger = LoggerFactory.getLogger(DefaultFileHeaderStrategy.class);
    public static final int CODEC_FILE_HEADER_MAGIC_VALUE = 189800062;
    public static final int MAGIC_VALUE_SIZE = 8;
    public static final int META_LENGTH_SIZE = 4;
    private MetaDataCodec metaCodec = new MetaDataCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer readMagicValue(File dataFile) throws IOException {
        RandomAccessFile raf = null;
        Integer result = null;
        try {
            raf = new RandomAccessFile(dataFile, "r");
            long fileLength = raf.length();
            if (fileLength >= 8L) {
                raf.seek(0L);
                int codecMagic = raf.readInt();
                if (codecMagic == 189800062) {
                    result = raf.readInt();
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Couldn't read magic value because codecMagic was 0x{} instead of 0x{}!", (Object)Integer.toHexString(codecMagic), (Object)Integer.toHexString(189800062));
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn("Couldn't read magic value because file size is {}!", (Object)fileLength);
            }
        }
        catch (Throwable throwable) {
            DefaultFileHeaderStrategy.closeQuietly(raf);
            throw throwable;
        }
        DefaultFileHeaderStrategy.closeQuietly(raf);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileHeader writeFileHeader(File dataFile, int magicValue, Map<String, String> metaData, boolean sparse) throws IOException {
        RandomAccessFile raf = null;
        FileHeader result = null;
        if (dataFile.isFile() && dataFile.length() > 0L) {
            throw new IllegalArgumentException("File '" + dataFile.getAbsolutePath() + "' already exists and has a size of " + dataFile.length() + ".");
        }
        try {
            raf = new RandomAccessFile(dataFile, "rw");
            raf.seek(0L);
            raf.writeInt(189800062);
            raf.writeInt(magicValue);
            byte[] buffer = null;
            int length = 0;
            MetaData resultMetaData = new MetaData(metaData, sparse);
            if ((metaData != null && metaData.size() > 0 || sparse) && (buffer = this.metaCodec.encode(resultMetaData)) != null) {
                length = buffer.length;
            }
            raf.writeInt(length);
            if (length > 0) {
                raf.write(buffer);
            }
            raf.close();
            raf = null;
            result = new FileHeader(magicValue, resultMetaData, 12 + length);
        }
        catch (Throwable throwable) {
            DefaultFileHeaderStrategy.closeQuietly(raf);
            throw throwable;
        }
        DefaultFileHeaderStrategy.closeQuietly(raf);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileHeader readFileHeader(File dataFile) throws IOException {
        FileHeader result;
        RandomAccessFile raf;
        block4: {
            raf = null;
            result = null;
            try {
                raf = new RandomAccessFile(dataFile, "r");
                if (raf.length() < 8L) break block4;
                raf.seek(0L);
                int codecMagic = raf.readInt();
                if (codecMagic != 189800062) break block4;
                int magicValue = raf.readInt();
                int offset = 8;
                raf.seek(offset);
                int metaLength = raf.readInt();
                if (metaLength > 0) {
                    if (raf.length() < (long)(offset + 4 + metaLength)) {
                        throw new IllegalArgumentException("Invalid length (" + metaLength + ") at offset: " + offset + "!");
                    }
                    raf.seek(offset + 4);
                    byte[] buffer = new byte[metaLength];
                    raf.readFully(buffer);
                    result = new FileHeader(magicValue, (MetaData)this.metaCodec.decode(buffer), offset + 4 + metaLength);
                    break block4;
                }
                result = new FileHeader(magicValue, new MetaData(false), offset + 4);
            }
            catch (Throwable throwable) {
                DefaultFileHeaderStrategy.closeQuietly(raf);
                throw throwable;
            }
        }
        DefaultFileHeaderStrategy.closeQuietly(raf);
        return result;
    }

    @Override
    public int getMinimalSize() {
        return 12;
    }

    private static void closeQuietly(RandomAccessFile raf) {
        block3: {
            Logger logger = LoggerFactory.getLogger(CodecFileBuffer.class);
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("Close on random access file threw exception!", (Throwable)e);
                }
            }
        }
    }
}

