/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.converter;

import de.huxhorn.lilith.data.converter.Converter;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterRegistry<T> {
    private final Map<Class<?>, Converter<T>> converterMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConverter(Converter<T> converter) {
        if (converter == null) {
            throw new IllegalArgumentException("Converter must not be null!");
        }
        Class clazz = converter.getSourceClass();
        if (clazz == null) {
            throw new IllegalStateException("Converter " + converter + " did not return a source class!");
        }
        Map<Class<?>, Converter<T>> map = this.converterMap;
        synchronized (map) {
            this.converterMap.put(clazz, converter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Converter<T> resolveConverter(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        Map<Class<?>, Converter<T>> map = this.converterMap;
        synchronized (map) {
            Converter<T> converter = this.converterMap.get(clazz);
            if (converter != null) {
                return converter;
            }
            for (Map.Entry<Class<?>, Converter<T>> current : this.converterMap.entrySet()) {
                Class<?> key = current.getKey();
                if (!key.isAssignableFrom(clazz)) continue;
                return current.getValue();
            }
            return null;
        }
    }
}

