/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.reflection;

import de.akquinet.jbosscc.needle.reflection.DerivedClassInterator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtil.class);
    private static final Map<Class<?>, Class<?>> PRIMITIVES = new HashMap();

    private ReflectionUtil() {
    }

    public static List<Field> getAllFieldsWithAnnotation(Class<?> clazz, final Class<? extends Annotation> annotation) {
        final ArrayList<Field> result = new ArrayList<Field>();
        new DerivedClassInterator(clazz){

            @Override
            protected void handleClass(Class<?> clazz) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (field.getAnnotation(annotation) == null) continue;
                    result.add(field);
                }
            }
        }.iterate();
        return result;
    }

    public static Map<Class<? extends Annotation>, List<Field>> getAllAnnotatedFields(Class<?> clazz) {
        HashMap<Class<? extends Annotation>, List<Field>> result = new HashMap<Class<? extends Annotation>, List<Field>>();
        List<Field> fields = ReflectionUtil.getAllFields(clazz);
        for (Field field : fields) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                ArrayList<Field> list = (ArrayList<Field>)result.get(annotationType);
                if (list == null) {
                    list = new ArrayList<Field>();
                }
                list.add(field);
                result.put(annotationType, list);
            }
        }
        return result;
    }

    public static List<Field> getAllFieldsAssinableFrom(final Class<?> assinableType, Class<?> clazz) {
        final ArrayList<Field> result = new ArrayList<Field>();
        new DerivedClassInterator(clazz){

            @Override
            protected void handleClass(Class<?> clazz) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!field.getType().isAssignableFrom(assinableType)) continue;
                    result.add(field);
                }
            }
        }.iterate();
        return result;
    }

    public static List<Field> getAllFieldsWithAnnotation(Object instance, Class<? extends Annotation> annotation) {
        return ReflectionUtil.getAllFieldsWithAnnotation(instance.getClass(), annotation);
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        final ArrayList<Field> result = new ArrayList<Field>();
        new DerivedClassInterator(clazz){

            @Override
            protected void handleClass(Class<?> clazz) {
                Field[] fields = clazz.getDeclaredFields();
                Collections.addAll(result, fields);
            }
        }.iterate();
        return result;
    }

    public static List<Method> getMethods(Class<?> clazz) {
        return Arrays.asList(clazz.getMethods());
    }

    public static void setFieldValue(Object object, Class<?> clazz, String fieldName, Object value) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(fieldName);
        try {
            ReflectionUtil.setField(field, object, value);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void setFieldValue(final Object object, final String fieldName, final Object value) {
        new DerivedClassInterator(object.getClass()){

            @Override
            protected void handleClass(Class<?> clazz) {
                try {
                    ReflectionUtil.setFieldValue(object, clazz, fieldName, value);
                    return;
                }
                catch (NoSuchFieldException e) {
                    LOG.warn("could not set field " + fieldName + " value " + value, (Throwable)e);
                    return;
                }
            }
        }.iterate();
    }

    public static Object getFieldValue(Object object, Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return ReflectionUtil.getFieldValue(object, field);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get field value: " + fieldName, e);
        }
    }

    public static Object getFieldValue(Object object, Field field) {
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not get field value: " + field, e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        return ReflectionUtil.getFieldValue(object, object.getClass(), fieldName);
    }

    public static Object invokeMethod(Object object, Class<?> clazz, String methodName, Object ... arguments) throws Exception {
        for (Class<?> superClazz = clazz; superClazz != null; superClazz = superClazz.getSuperclass()) {
            for (Method declaredMethod : superClazz.getDeclaredMethods()) {
                Class<?>[] parameterTypes;
                if (!declaredMethod.getName().equals(methodName) || (parameterTypes = declaredMethod.getParameterTypes()).length != arguments.length || !ReflectionUtil.checkArguments(parameterTypes, arguments)) continue;
                return ReflectionUtil.invokeMethod(declaredMethod, object, arguments);
            }
        }
        throw new IllegalArgumentException("Method " + methodName + ":" + Arrays.toString(arguments) + " not found");
    }

    public static Object invokeMethod(Method method, Object instance, Object ... arguments) throws Exception {
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(instance, arguments);
        }
        catch (Exception exc) {
            LOG.warn("Error invoking method: " + method.getName(), (Throwable)exc);
            Throwable cause = exc.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw exc;
        }
    }

    public static Method getMethod(Class<?> clazz, final String methodName, final Class<?> ... parameterTypes) throws NoSuchMethodException {
        final ArrayList result = new ArrayList();
        new DerivedClassInterator(clazz){

            @Override
            protected void handleClass(Class<?> clazz) {
                try {
                    result.add(clazz.getDeclaredMethod(methodName, parameterTypes));
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }.iterate();
        if (result.isEmpty()) {
            throw new NoSuchMethodException(methodName);
        }
        return (Method)result.get(0);
    }

    private static boolean checkArguments(Class<?>[] parameterTypes, Object[] arguments) {
        boolean match = true;
        for (int i = 0; i < arguments.length; ++i) {
            Class<?> parameterClass = parameterTypes[i];
            Class<?> argumentClass = arguments[i].getClass();
            if (parameterClass.isAssignableFrom(argumentClass) || ReflectionUtil.checkPrimativeArguments(parameterClass, argumentClass)) continue;
            match = false;
        }
        return match;
    }

    private static boolean checkPrimativeArguments(Class<?> parameterClass, Class<?> argumentClass) {
        boolean result = false;
        for (Map.Entry<Class<?>, Class<?>> entry : PRIMITIVES.entrySet()) {
            result = result || parameterClass == entry.getKey() && argumentClass == entry.getValue();
        }
        return result;
    }

    public static Object invokeMethod(Object object, String methodName, Object ... arguments) throws Exception {
        return ReflectionUtil.invokeMethod(object, object.getClass(), methodName, arguments);
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static void setField(Field field, Object target, Object value) throws Exception {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(target, value);
    }

    public static void setField(String fieldName, Object target, Object value) throws Exception {
        Field field = ReflectionUtil.getField(target.getClass(), fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        field.set(target, value);
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Field field = null;
        field = ReflectionUtil.getFieldByName(clazz, fieldName);
        for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null && field == null; superClazz = superClazz.getSuperclass()) {
            field = ReflectionUtil.getFieldByName(superClazz, fieldName);
        }
        return field;
    }

    private static Field getFieldByName(Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static <T> T createInstance(Class<T> clazz, Object ... parameter) throws Exception {
        Class[] parameterTypes = new Class[parameter.length];
        for (int i = 0; i < parameter.length; ++i) {
            parameterTypes[i] = parameter[i].getClass();
        }
        Constructor<T> constructor = clazz.getConstructor(parameterTypes);
        return constructor.newInstance(parameter);
    }

    static {
        PRIMITIVES.put(Integer.TYPE, Integer.class);
        PRIMITIVES.put(Double.TYPE, Double.class);
        PRIMITIVES.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES.put(Long.TYPE, Long.class);
        PRIMITIVES.put(Float.TYPE, Float.class);
        PRIMITIVES.put(Character.TYPE, Character.class);
        PRIMITIVES.put(Short.TYPE, Short.class);
        PRIMITIVES.put(Byte.TYPE, Byte.class);
    }
}

