/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.injection;

import de.akquinet.jbosscc.needle.common.MapEntry;
import de.akquinet.jbosscc.needle.configuration.NeedleConfiguration;
import de.akquinet.jbosscc.needle.injection.DefaultMockInjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionProvider;
import de.akquinet.jbosscc.needle.injection.InjectionTargetInformation;
import de.akquinet.jbosscc.needle.injection.MockProviderInjectionProvider;
import de.akquinet.jbosscc.needle.injection.ResourceMockInjectionProvider;
import de.akquinet.jbosscc.needle.mock.MockProvider;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InjectionConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(InjectionConfiguration.class);
    private static final Class<?> RESOURCE_CLASS = InjectionConfiguration.getClass("javax.annotation.Resource");
    private static final Class<?> INJECT_CLASS = InjectionConfiguration.getClass("javax.inject.Inject");
    private static final Class<?> EJB_CLASS = InjectionConfiguration.getClass("javax.ejb.EJB");
    private static final Class<?> PERSISTENCE_CONTEXT_CLASS = InjectionConfiguration.getClass("javax.persistence.PersistenceContext");
    private static final Class<?> PERSISTENCE_UNIT_CLASS = InjectionConfiguration.getClass("javax.persistence.PersistenceUnit");
    private static final Class<? extends MockProvider> MOCK_PROVIDER_CLASS = InjectionConfiguration.lookupMockProviderClass(NeedleConfiguration.getMockProviderClassName());
    private final List<InjectionProvider<?>> injectionProviderList = new ArrayList();
    private final List<InjectionProvider<?>> globalInjectionProviderList = new ArrayList();
    private final List<InjectionProvider<?>> testInjectionProvider = new ArrayList();
    private final List<List<InjectionProvider<?>>> allInjectionProvider;
    private final Set<Class<? extends Annotation>> injectionAnnotationClasses = new HashSet<Class<? extends Annotation>>();
    private final MockProvider mockProvider = this.createMockProvider();

    public InjectionConfiguration() {
        this.add(INJECT_CLASS);
        this.add(EJB_CLASS);
        this.add(PERSISTENCE_CONTEXT_CLASS);
        this.add(PERSISTENCE_UNIT_CLASS);
        this.addResource();
        this.initGlobalInjectionAnnotation();
        this.initGlobalInjectionProvider();
        this.injectionProviderList.add(0, new MockProviderInjectionProvider(this.mockProvider));
        this.allInjectionProvider = Arrays.asList(this.testInjectionProvider, this.globalInjectionProviderList, this.injectionProviderList);
    }

    private void addResource() {
        if (RESOURCE_CLASS != null) {
            this.addInjectionAnnotation(RESOURCE_CLASS);
            this.injectionProviderList.add(new ResourceMockInjectionProvider(this.mockProvider));
        }
    }

    private void add(Class<?> clazz) {
        if (clazz != null) {
            LOG.debug("register injection handler for class {}", clazz);
            this.injectionProviderList.add(new DefaultMockInjectionProvider(clazz, this.mockProvider));
            this.addInjectionAnnotation(clazz);
        }
    }

    private static Class<?> getClass(String className) {
        return ReflectionUtil.forName(className);
    }

    public <T extends MockProvider> T getMockProvider() {
        return (T)this.mockProvider;
    }

    public final void addInjectionProvider(InjectionProvider<?> ... injectionProvider) {
        for (InjectionProvider<?> provider : injectionProvider) {
            this.testInjectionProvider.add(0, provider);
        }
    }

    public List<List<InjectionProvider<?>>> getInjectionProvider() {
        return this.allInjectionProvider;
    }

    private void initGlobalInjectionAnnotation() {
        Set<Class<Annotation>> customInjectionAnnotations = NeedleConfiguration.getCustomInjectionAnnotations();
        for (Class<Annotation> annotation : customInjectionAnnotations) {
            this.addInjectionAnnotation(annotation);
            this.globalInjectionProviderList.add(0, new DefaultMockInjectionProvider(annotation, (MockProvider)this.getMockProvider()));
        }
    }

    private void initGlobalInjectionProvider() {
        Set<Class<InjectionProvider<?>>> customInjectionProviders = NeedleConfiguration.getCustomInjectionProviderClasses();
        for (Class<InjectionProvider<?>> injectionProviderClass : customInjectionProviders) {
            try {
                InjectionProvider<?> injection = ReflectionUtil.createInstance(injectionProviderClass, new Object[0]);
                this.globalInjectionProviderList.add(0, injection);
            }
            catch (Exception e) {
                LOG.warn("could not create an instance of injection provider " + injectionProviderClass, (Throwable)e);
            }
        }
    }

    private void addInjectionAnnotation(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            this.injectionAnnotationClasses.add(clazz);
        }
    }

    public boolean isAnnotationSupported(Class<? extends Annotation> annotation) {
        return this.injectionAnnotationClasses.contains(annotation);
    }

    Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return Collections.unmodifiableSet(this.injectionAnnotationClasses);
    }

    public Map.Entry<Object, Object> handleInjectionProvider(Collection<InjectionProvider<?>> injectionProviders, InjectionTargetInformation injectionTargetInformation) {
        for (InjectionProvider<?> provider : injectionProviders) {
            if (!provider.verify(injectionTargetInformation)) continue;
            Object object = provider.getInjectedObject(injectionTargetInformation.getType());
            Object key = provider.getKey(injectionTargetInformation);
            return new MapEntry<Object, Object>(key, object);
        }
        return null;
    }

    <T extends MockProvider> T createMockProvider() {
        try {
            return (T)MOCK_PROVIDER_CLASS.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("could not create a new instance of mock provider " + MOCK_PROVIDER_CLASS, e);
        }
    }

    static Class<? extends MockProvider> lookupMockProviderClass(String mockProviderClassName) {
        try {
            if (mockProviderClassName != null) {
                return Class.forName(mockProviderClassName);
            }
        }
        catch (Exception e) {
            LOG.warn("could not load mock provider class " + mockProviderClassName, (Throwable)e);
        }
        throw new RuntimeException("no mock provider configured");
    }
}

