/*
 * Decompiled with CFR 0.152.
 */
package com.wordnik.swagger.jersey;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import com.wordnik.swagger.converter.ModelConverters;
import com.wordnik.swagger.jaxrs.ext.AbstractSwaggerExtension;
import com.wordnik.swagger.jaxrs.ext.SwaggerExtension;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.Parameter;
import com.wordnik.swagger.models.properties.Property;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwaggerJerseyJaxrs
extends AbstractSwaggerExtension
implements SwaggerExtension {
    static Logger LOGGER = LoggerFactory.getLogger(SwaggerJerseyJaxrs.class);

    public List<Parameter> extractParameters(Annotation[] annotations, Class<?> cls, boolean isArray, Set<Class<?>> classesToSkip, Iterator<SwaggerExtension> chain) {
        ArrayList<Parameter> output = new ArrayList<Parameter>();
        if (this.shouldIgnoreClass(cls) || classesToSkip.contains(cls)) {
            classesToSkip.add(cls);
            return output;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof FormDataParam)) continue;
            FormDataParam fd = (FormDataParam)annotation;
            if (InputStream.class.equals(cls)) {
                FormParameter param = new FormParameter().type("file").name(fd.value());
                output.add((Parameter)param);
                return output;
            }
            FormParameter fp = new FormParameter().name(fd.value());
            Property schema = ModelConverters.getInstance().readAsProperty(cls);
            if (schema != null) {
                fp.setProperty(schema);
            }
            output.add((Parameter)fp);
            return output;
        }
        if (chain.hasNext()) {
            return chain.next().extractParameters(annotations, cls, isArray, classesToSkip, chain);
        }
        return null;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        boolean output = false;
        output = FormDataContentDisposition.class.equals(cls);
        LOGGER.debug("should ignore " + cls + ": " + output);
        return output;
    }
}

