/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs.model;

import java.util.Set;
import javax.lang.model.type.TypeKind;

public interface ResourceParameterConstraints {
    public ResourceParameterConstraintType getType();

    public static class Enumeration
    implements ResourceParameterConstraints {
        private final Set<String> values;

        public Enumeration(Set<String> values) {
            this.values = values;
        }

        @Override
        public ResourceParameterConstraintType getType() {
            return ResourceParameterConstraintType.ENUMERATION;
        }

        public Set<String> getValues() {
            return this.values;
        }
    }

    public static class Regex
    implements ResourceParameterConstraints {
        private final String regex;

        public Regex(String regex) {
            this.regex = regex;
        }

        @Override
        public ResourceParameterConstraintType getType() {
            return ResourceParameterConstraintType.REGEX;
        }

        public String getRegex() {
            return this.regex;
        }
    }

    public static class Primitive
    implements ResourceParameterConstraints {
        private final TypeKind kind;

        public Primitive(TypeKind kind) {
            this.kind = kind;
        }

        public TypeKind getKind() {
            return this.kind;
        }

        @Override
        public ResourceParameterConstraintType getType() {
            return ResourceParameterConstraintType.PRIMITIVE;
        }
    }

    public static enum Unbound implements ResourceParameterConstraints
    {
        STRING;


        @Override
        public ResourceParameterConstraintType getType() {
            return ResourceParameterConstraintType.UNBOUND_STRING;
        }
    }

    public static enum ResourceParameterConstraintType {
        UNBOUND_STRING,
        PRIMITIVE,
        REGEX,
        ENUMERATION;

    }
}

