/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.jaxrs;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.BaseArtifact;
import com.webcohesion.enunciate.modules.jaxrs.EnunciateJaxrsContext;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import javax.lang.model.element.TypeElement;

public class JaxrsProviderClassListArtifact
extends BaseArtifact {
    private final EnunciateJaxrsContext jaxrsContext;
    private final Date created = new Date();

    public JaxrsProviderClassListArtifact(EnunciateJaxrsContext jaxrsContext) {
        super("jaxrs", "jaxrs-provider-classes.list");
        this.jaxrsContext = jaxrsContext;
        this.setBelongsOnServerSideClasspath(true);
    }

    public String getName() {
        return "jaxrs-provider-classes.list";
    }

    public String getDescription() {
        return "A plain text file that contains the list of all JAX-RS providers in the current project.";
    }

    public boolean isPublic() {
        return false;
    }

    public Date getCreated() {
        return this.created;
    }

    public void exportTo(File fileOrDirectory, Enunciate enunciate) throws IOException {
        FileWriter out = new FileWriter(fileOrDirectory.isDirectory() ? new File(fileOrDirectory, this.getName()) : fileOrDirectory);
        HashSet<String> written = new HashSet<String>();
        for (TypeElement provider : this.jaxrsContext.getProviders()) {
            if (!written.add(provider.getQualifiedName().toString())) continue;
            out.write(provider.getQualifiedName() + "\n");
        }
        out.flush();
        out.close();
    }

    public long getSize() {
        return -1L;
    }
}

