/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.convert.html;

import com.vladsch.flexmark.convert.html.FlexmarkHtmlParser;
import com.vladsch.flexmark.util.Utils;
import com.vladsch.flexmark.util.format.TableFormatOptions;
import com.vladsch.flexmark.util.html.CellAlignment;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import com.vladsch.flexmark.util.options.MutableDataSetter;
import java.util.Map;

public class HtmlParserOptions
implements MutableDataSetter {
    public boolean listContentIndent;
    public boolean setextHeadings;
    public boolean outputUnknownTags;
    public boolean typographicQuotes;
    public boolean typographicSmarts;
    public boolean wrapAutoLinks;
    public boolean extractAutoLinks;
    public boolean renderComments;
    public boolean dotOnlyNumericLists;
    public char orderedListDelimiter;
    public char unorderedListDelimiter;
    public int definitionMarkerSpaces;
    public int minSetextHeadingMarkerLength;
    public String codeIndent;
    public String eolInTitleAttribute;
    public String nbspText;
    public String thematicBreak;
    public Map<Object, CellAlignment> tableCellAlignmentMap;
    public TableFormatOptions tableOptions;

    HtmlParserOptions() {
        this((DataHolder)null);
    }

    HtmlParserOptions(HtmlParserOptions other) {
        this.listContentIndent = other.listContentIndent;
        this.setextHeadings = other.setextHeadings;
        this.outputUnknownTags = other.outputUnknownTags;
        this.typographicQuotes = other.typographicQuotes;
        this.typographicSmarts = other.typographicSmarts;
        this.wrapAutoLinks = other.wrapAutoLinks;
        this.extractAutoLinks = other.extractAutoLinks;
        this.renderComments = other.renderComments;
        this.dotOnlyNumericLists = other.dotOnlyNumericLists;
        this.orderedListDelimiter = other.orderedListDelimiter;
        this.unorderedListDelimiter = other.unorderedListDelimiter;
        this.definitionMarkerSpaces = other.definitionMarkerSpaces;
        this.minSetextHeadingMarkerLength = other.minSetextHeadingMarkerLength;
        this.codeIndent = other.codeIndent;
        this.eolInTitleAttribute = other.eolInTitleAttribute;
        this.nbspText = other.nbspText;
        this.thematicBreak = other.thematicBreak;
        this.tableCellAlignmentMap = other.tableCellAlignmentMap;
        this.tableOptions = other.tableOptions;
    }

    HtmlParserOptions(DataHolder options) {
        this.listContentIndent = (Boolean)FlexmarkHtmlParser.LIST_CONTENT_INDENT.getFrom(options);
        this.setextHeadings = (Boolean)FlexmarkHtmlParser.SETEXT_HEADINGS.getFrom(options);
        this.outputUnknownTags = (Boolean)FlexmarkHtmlParser.OUTPUT_UNKNOWN_TAGS.getFrom(options);
        this.typographicQuotes = (Boolean)FlexmarkHtmlParser.TYPOGRAPHIC_QUOTES.getFrom(options);
        this.typographicSmarts = (Boolean)FlexmarkHtmlParser.TYPOGRAPHIC_SMARTS.getFrom(options);
        this.wrapAutoLinks = (Boolean)FlexmarkHtmlParser.WRAP_AUTO_LINKS.getFrom(options);
        this.extractAutoLinks = (Boolean)FlexmarkHtmlParser.EXTRACT_AUTO_LINKS.getFrom(options);
        this.renderComments = (Boolean)FlexmarkHtmlParser.RENDER_COMMENTS.getFrom(options);
        this.dotOnlyNumericLists = (Boolean)FlexmarkHtmlParser.DOT_ONLY_NUMERIC_LISTS.getFrom(options);
        this.orderedListDelimiter = ((Character)FlexmarkHtmlParser.ORDERED_LIST_DELIMITER.getFrom(options)).charValue();
        this.unorderedListDelimiter = ((Character)FlexmarkHtmlParser.UNORDERED_LIST_DELIMITER.getFrom(options)).charValue();
        this.definitionMarkerSpaces = (Integer)FlexmarkHtmlParser.DEFINITION_MARKER_SPACES.getFrom(options);
        this.minSetextHeadingMarkerLength = Utils.minLimit((int)((Integer)FlexmarkHtmlParser.MIN_SETEXT_HEADING_MARKER_LENGTH.getFrom(options)), (int[])new int[]{3});
        this.codeIndent = (String)FlexmarkHtmlParser.CODE_INDENT.getFrom(options);
        this.eolInTitleAttribute = (String)FlexmarkHtmlParser.EOL_IN_TITLE_ATTRIBUTE.getFrom(options);
        this.nbspText = (String)FlexmarkHtmlParser.NBSP_TEXT.getFrom(options);
        this.thematicBreak = (String)FlexmarkHtmlParser.THEMATIC_BREAK.getFrom(options);
        this.tableCellAlignmentMap = (Map)FlexmarkHtmlParser.TABLE_CELL_ALIGNMENT_MAP.getFrom(options);
        this.tableOptions = new TableFormatOptions(options);
    }

    public MutableDataHolder setIn(MutableDataHolder dataHolder) {
        dataHolder.set(FlexmarkHtmlParser.LIST_CONTENT_INDENT, (Object)this.listContentIndent);
        dataHolder.set(FlexmarkHtmlParser.SETEXT_HEADINGS, (Object)this.setextHeadings);
        dataHolder.set(FlexmarkHtmlParser.OUTPUT_UNKNOWN_TAGS, (Object)this.outputUnknownTags);
        dataHolder.set(FlexmarkHtmlParser.TYPOGRAPHIC_QUOTES, (Object)this.typographicQuotes);
        dataHolder.set(FlexmarkHtmlParser.TYPOGRAPHIC_SMARTS, (Object)this.typographicSmarts);
        dataHolder.set(FlexmarkHtmlParser.WRAP_AUTO_LINKS, (Object)this.wrapAutoLinks);
        dataHolder.set(FlexmarkHtmlParser.EXTRACT_AUTO_LINKS, (Object)this.extractAutoLinks);
        dataHolder.set(FlexmarkHtmlParser.RENDER_COMMENTS, (Object)this.renderComments);
        dataHolder.set(FlexmarkHtmlParser.DOT_ONLY_NUMERIC_LISTS, (Object)this.dotOnlyNumericLists);
        dataHolder.set(FlexmarkHtmlParser.ORDERED_LIST_DELIMITER, (Object)Character.valueOf(this.orderedListDelimiter));
        dataHolder.set(FlexmarkHtmlParser.UNORDERED_LIST_DELIMITER, (Object)Character.valueOf(this.unorderedListDelimiter));
        dataHolder.set(FlexmarkHtmlParser.DEFINITION_MARKER_SPACES, (Object)this.definitionMarkerSpaces);
        dataHolder.set(FlexmarkHtmlParser.MIN_SETEXT_HEADING_MARKER_LENGTH, (Object)this.minSetextHeadingMarkerLength);
        dataHolder.set(FlexmarkHtmlParser.CODE_INDENT, (Object)this.codeIndent);
        dataHolder.set(FlexmarkHtmlParser.EOL_IN_TITLE_ATTRIBUTE, (Object)this.eolInTitleAttribute);
        dataHolder.set(FlexmarkHtmlParser.NBSP_TEXT, (Object)this.nbspText);
        dataHolder.set(FlexmarkHtmlParser.THEMATIC_BREAK, (Object)this.thematicBreak);
        dataHolder.set(FlexmarkHtmlParser.TABLE_CELL_ALIGNMENT_MAP, this.tableCellAlignmentMap);
        dataHolder.setFrom((MutableDataSetter)this.tableOptions);
        return dataHolder;
    }
}

