/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vaadin.base.devserver.stats.DevModeUsageStatistics;
import com.vaadin.base.devserver.stats.JsonHelpers;
import com.vaadin.base.devserver.stats.ProjectHelpers;
import com.vaadin.base.devserver.stats.StatisticsContainer;
import com.vaadin.flow.server.Command;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsStorage {
    private String projectId;
    File usageStatisticsFile;

    private static Logger getLogger() {
        return LoggerFactory.getLogger(StatisticsStorage.class);
    }

    void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    String getProjectId() {
        return this.projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(Command whenLocked) {
        Class<DevModeUsageStatistics> clazz = DevModeUsageStatistics.class;
        synchronized (DevModeUsageStatistics.class) {
            whenLocked.execute();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void update(BiConsumer<StatisticsContainer, StatisticsContainer> updater) {
        this.access((Command & Serializable)() -> {
            ObjectNode fullJson = this.internalRead();
            ObjectNode projectJson = StatisticsStorage.getProjectData(fullJson, this.projectId);
            updater.accept(new StatisticsContainer(fullJson), new StatisticsContainer(projectJson));
            this.internalWrite(fullJson);
        });
    }

    private static ObjectNode getProjectData(ObjectNode fullJson, String projectId) {
        if (projectId == null) {
            return null;
        }
        return JsonHelpers.getOrCreate(projectId, fullJson.get("projects"), "id", true);
    }

    ObjectNode read() {
        AtomicReference<Object> data = new AtomicReference<Object>(null);
        this.access((Command & Serializable)() -> data.set(this.internalRead()));
        return data.get();
    }

    ObjectNode readProject() {
        ObjectNode data = this.read();
        return StatisticsStorage.getProjectData(data, this.projectId);
    }

    private ObjectNode internalRead() {
        File file = this.getUsageStatisticsFile();
        StatisticsStorage.getLogger().debug("Reading statistics from {}", (Object)file.getAbsolutePath());
        try {
            if (file.exists()) {
                return (ObjectNode)JsonHelpers.getJsonMapper().readTree(file);
            }
        }
        catch (Exception e) {
            StatisticsStorage.getLogger().debug("Failed to parse json", (Throwable)e);
        }
        ObjectNode json = JsonHelpers.getJsonMapper().createObjectNode();
        json.set("projects", (JsonNode)JsonHelpers.getJsonMapper().createArrayNode());
        return json;
    }

    private void internalWrite(ObjectNode json) {
        try {
            this.getUsageStatisticsFile().getParentFile().mkdirs();
            JsonHelpers.getJsonMapper().writeValue(this.getUsageStatisticsFile(), (Object)json);
        }
        catch (IOException e) {
            StatisticsStorage.getLogger().debug("Failed to write json", (Throwable)e);
        }
    }

    File getUsageStatisticsFile() {
        if (this.usageStatisticsFile == null) {
            this.usageStatisticsFile = ProjectHelpers.resolveStatisticsStore();
        }
        return this.usageStatisticsFile;
    }

    void clearAllProjectData() {
        this.update((global, project) -> global.setValue("projects", (JsonNode)JsonHelpers.getJsonMapper().createArrayNode()));
    }
}

