/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.engine.commandrunner;

import com.vaadin.hilla.engine.commandrunner.CommandRunner;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRunner
implements CommandRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenRunner.class);
    static final String EXECUTABLE_PROPERTY = "hilla.mavenExecutable";
    private final File projectDir;
    private final String[] args;

    public MavenRunner(File projectDir, String ... args) {
        this.projectDir = projectDir;
        this.args = args;
    }

    public static Optional<CommandRunner> forProject(File projectDir, String ... args) {
        if (new File(projectDir, "pom.xml").exists()) {
            return Optional.of(new MavenRunner(projectDir, args));
        }
        return Optional.empty();
    }

    @Override
    public String[] arguments() {
        return this.args;
    }

    @Override
    public String[] testArguments() {
        return new String[]{"-v"};
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public File currentDirectory() {
        return this.projectDir;
    }

    @Override
    public List<String> executables() {
        ArrayList<String> executableList = new ArrayList<String>();
        String customExecutable = System.getProperty(EXECUTABLE_PROPERTY);
        if (customExecutable != null) {
            executableList.add(customExecutable);
        }
        if (IS_WINDOWS) {
            executableList.add(".\\mvnw.cmd");
            executableList.add("mvn.cmd");
        } else {
            executableList.add("./mvnw");
            executableList.add("mvn");
        }
        return List.copyOf(executableList);
    }
}

