/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.impl.ShadowRootStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ShadowRootHost;

public class ShadowRoot
extends Node<ShadowRoot> {
    private ShadowRoot(StateNode node) {
        super(node, ShadowRootStateProvider.get());
    }

    public static ShadowRoot get(StateNode node) {
        assert (node != null);
        if (ShadowRoot.isShadowRoot(node)) {
            return new ShadowRoot(node);
        }
        throw new IllegalArgumentException("Node is not valid as an element");
    }

    public static boolean isShadowRoot(StateNode node) {
        return node.hasFeature(ShadowRootHost.class);
    }

    @Override
    public Node<?> getParentNode() {
        return null;
    }

    public Element getHost() {
        Node parent = this.getStateProvider().getParent(this.getNode());
        assert (parent instanceof Element);
        return (Element)parent;
    }

    @Override
    protected ShadowRoot getSelf() {
        return this;
    }

    @Override
    public ShadowRootStateProvider getStateProvider() {
        return (ShadowRootStateProvider)super.getStateProvider();
    }
}

