/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import java.io.Serializable;

public class RouteParameterRegex
implements Serializable {
    public static final String INTEGER = "^[-+]?\\d+$";
    public static final String LONG = "^[+-]?[0-9]{1,19}$";
    public static final String BOOLEAN = "^true|false$";

    private RouteParameterRegex() {
    }

    public static String getRegex(Class<?> parameterType) {
        String regex = null;
        if (parameterType.isAssignableFrom(Integer.class)) {
            regex = INTEGER;
        } else if (parameterType.isAssignableFrom(Long.class)) {
            regex = LONG;
        } else if (parameterType.isAssignableFrom(Boolean.class)) {
            regex = BOOLEAN;
        }
        return regex;
    }

    public static Class<?> getType(String regex) {
        if (INTEGER.equalsIgnoreCase(regex)) {
            return Integer.class;
        }
        if (LONG.equalsIgnoreCase(regex)) {
            return Long.class;
        }
        if (BOOLEAN.equalsIgnoreCase(regex)) {
            return Boolean.class;
        }
        return String.class;
    }

    public static String getName(String regex) {
        return RouteParameterRegex.getType(regex).getSimpleName().toLowerCase();
    }
}

