/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filter;

import com.sun.grizzly.Context;
import com.sun.grizzly.filter.ReadFilter;
import com.sun.grizzly.util.WorkerThread;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;

public class UDPReadFilter
extends ReadFilter {
    public static final String UDP_SOCKETADDRESS = "socketAddress";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        boolean result = true;
        SocketAddress socketAddress = null;
        DatagramChannel datagramChannel = null;
        Exception exception = null;
        SelectionKey key = ctx.getSelectionKey();
        key.attach(null);
        ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        try {
            datagramChannel = (DatagramChannel)key.channel();
            socketAddress = datagramChannel.receive(byteBuffer);
        }
        catch (IOException ex) {
            exception = ex;
            this.log("UDPReadFilter.execute", ex);
        }
        catch (RuntimeException ex) {
            exception = ex;
            this.log("UDPReadFilter.execute", ex);
        }
        finally {
            if (exception != null) {
                ctx.setAttribute("throwable", exception);
                result = false;
            } else if (socketAddress == null) {
                ctx.setKeyRegistrationState(Context.KeyRegistrationState.REGISTER);
                result = false;
            } else {
                ctx.setAttribute(UDP_SOCKETADDRESS, socketAddress);
            }
        }
        return result;
    }
}

