/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;

public class JavadocTag {
    private final int lineNo;
    private int columnNo;
    private final String arg1;
    private final JavadocTagInfo tagInfo;

    public JavadocTag(int line, int column, String tag, String arg1) {
        this.lineNo = line;
        this.columnNo = column;
        this.arg1 = arg1;
        this.tagInfo = JavadocTagInfo.fromName(tag);
    }

    public JavadocTag(int line, int column, String tag) {
        this(line, column, tag, null);
    }

    public String getTagName() {
        return this.tagInfo.getName();
    }

    public String getArg1() {
        return this.arg1;
    }

    public int getLineNo() {
        return this.lineNo;
    }

    public int getColumnNo() {
        return this.columnNo;
    }

    public String toString() {
        return "{Tag = '" + this.getTagName() + "', lineNo = " + this.getLineNo() + ", columnNo=" + this.columnNo + ", Arg1 = '" + this.getArg1() + "'}";
    }

    public boolean isAuthorTag() {
        return JavadocTagInfo.AUTHOR.equals((Object)this.tagInfo);
    }

    public boolean isReturnTag() {
        return JavadocTagInfo.RETURN.equals((Object)this.tagInfo);
    }

    public boolean isParamTag() {
        return JavadocTagInfo.PARAM.equals((Object)this.tagInfo);
    }

    public boolean isThrowsTag() {
        return JavadocTagInfo.THROWS.equals((Object)this.tagInfo) || JavadocTagInfo.EXCEPTION.equals((Object)this.tagInfo);
    }

    public boolean isSeeOrInheritDocTag() {
        return JavadocTagInfo.SEE.equals((Object)this.tagInfo) || this.isInheritDocTag();
    }

    public boolean isInheritDocTag() {
        return JavadocTagInfo.INHERIT_DOC.equals((Object)this.tagInfo);
    }

    public boolean canReferenceImports() {
        return JavadocTagInfo.SEE.equals((Object)this.tagInfo) || JavadocTagInfo.LINK.equals((Object)this.tagInfo) || JavadocTagInfo.LINKPLAIN.equals((Object)this.tagInfo) || JavadocTagInfo.THROWS.equals((Object)this.tagInfo) || JavadocTagInfo.EXCEPTION.equals((Object)this.tagInfo);
    }
}

