/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public final class AnnotationUtility {
    private AnnotationUtility() {
        throw new UnsupportedOperationException("do not instantiate.");
    }

    public static boolean containsAnnotation(DetailAST ast, String annotation) {
        return AnnotationUtility.getAnnotation(ast, annotation) != null;
    }

    public static boolean containsAnnotation(DetailAST ast) {
        DetailAST holder = AnnotationUtility.getAnnotationHolder(ast);
        return holder != null && holder.branchContains(159);
    }

    public static DetailAST getAnnotationHolder(DetailAST ast) {
        if (ast == null) {
            throw new NullPointerException("the ast is null");
        }
        DetailAST annotationHolder = ast.getType() == 155 || ast.getType() == 16 ? ast.findFirstToken(158) : ast.findFirstToken(5);
        return annotationHolder;
    }

    public static DetailAST getAnnotation(DetailAST ast, String annotation) {
        if (ast == null) {
            throw new NullPointerException("the ast is null");
        }
        if (annotation == null) {
            throw new NullPointerException("the annotation is null");
        }
        if (annotation.trim().length() == 0) {
            throw new IllegalArgumentException("the annotationis empty or spaces");
        }
        DetailAST holder = AnnotationUtility.getAnnotationHolder(ast);
        for (DetailAST child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            DetailAST at;
            String name;
            if (child.getType() != 159 || !annotation.equals(name = FullIdent.createFullIdent((at = child.getFirstChild()).getNextSibling()).getText())) continue;
            return child;
        }
        return null;
    }

    public static DetailAST annotatingWhat(DetailAST ast) {
        if (ast == null) {
            throw new NullPointerException("the ast is null");
        }
        if (ast.getType() != 159) {
            throw new IllegalArgumentException("The ast is not an annotation. AST: " + (Object)((Object)ast));
        }
        return ast.getParent().getParent();
    }

    public static boolean isAnnotatingType(DetailAST ast, int tokenType) {
        DetailAST astNode = AnnotationUtility.annotatingWhat(ast);
        return astNode.getType() == tokenType;
    }
}

