/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.ModuleFactory;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.util.Set;

class PackageObjectFactory
implements ModuleFactory {
    private final Set<String> packages;
    private final ClassLoader moduleClassLoader;

    public PackageObjectFactory(Set<String> packageNames, ClassLoader moduleClassLoader) {
        if (moduleClassLoader == null) {
            throw new IllegalArgumentException("moduleClassLoader must not be null");
        }
        this.packages = Sets.newLinkedHashSet(packageNames);
        this.moduleClassLoader = moduleClassLoader;
    }

    void addPackage(String packageName) {
        this.packages.add(packageName);
    }

    private Object doMakeObject(String name) throws CheckstyleException {
        try {
            return this.createObject(name);
        }
        catch (CheckstyleException ex) {
            for (String packageName : this.packages) {
                String className = packageName + name;
                try {
                    return this.createObject(className);
                }
                catch (CheckstyleException ex2) {
                }
            }
            throw new CheckstyleException("Unable to instantiate " + name);
        }
    }

    private Object createObject(String className) throws CheckstyleException {
        try {
            Class<?> clazz = Class.forName(className, true, this.moduleClassLoader);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new CheckstyleException("Unable to find class for " + className, e);
        }
        catch (InstantiationException e) {
            throw new CheckstyleException("Unable to instantiate " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new CheckstyleException("Unable to instantiate " + className, e);
        }
    }

    @Override
    public Object createModule(String name) throws CheckstyleException {
        try {
            return this.doMakeObject(name);
        }
        catch (CheckstyleException ex) {
            try {
                return this.doMakeObject(name + "Check");
            }
            catch (CheckstyleException ex2) {
                throw new CheckstyleException("Unable to instantiate " + name, ex2);
            }
        }
    }
}

