/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.JavadocTagInfo;

public class JavadocTag {
    private final int mLineNo;
    private int mColumnNo;
    private final String mArg1;
    private final JavadocTagInfo mTagInfo;

    public JavadocTag(int aLine, int aColumn, String aTag, String aArg1) {
        this.mLineNo = aLine;
        this.mColumnNo = aColumn;
        this.mArg1 = aArg1;
        this.mTagInfo = JavadocTagInfo.fromName(aTag);
    }

    public JavadocTag(int aLine, int aColumn, String aTag) {
        this(aLine, aColumn, aTag, null);
    }

    public String getTagName() {
        return this.mTagInfo.getName();
    }

    public String getArg1() {
        return this.mArg1;
    }

    public int getLineNo() {
        return this.mLineNo;
    }

    public int getColumnNo() {
        return this.mColumnNo;
    }

    public String toString() {
        return "{Tag = '" + this.getTagName() + "', lineNo = " + this.getLineNo() + ", columnNo=" + this.mColumnNo + ", Arg1 = '" + this.getArg1() + "'}";
    }

    public boolean isAuthorTag() {
        return JavadocTagInfo.AUTHOR.equals((Object)this.mTagInfo);
    }

    public boolean isReturnTag() {
        return JavadocTagInfo.RETURN.equals((Object)this.mTagInfo);
    }

    public boolean isParamTag() {
        return JavadocTagInfo.PARAM.equals((Object)this.mTagInfo);
    }

    public boolean isThrowsTag() {
        return JavadocTagInfo.THROWS.equals((Object)this.mTagInfo) || JavadocTagInfo.EXCEPTION.equals((Object)this.mTagInfo);
    }

    public boolean isSeeOrInheritDocTag() {
        return JavadocTagInfo.SEE.equals((Object)this.mTagInfo) || this.isInheritDocTag();
    }

    public boolean isInheritDocTag() {
        return JavadocTagInfo.INHERIT_DOC.equals((Object)this.mTagInfo);
    }

    public boolean canReferenceImports() {
        return JavadocTagInfo.SEE.equals((Object)this.mTagInfo) || JavadocTagInfo.LINK.equals((Object)this.mTagInfo) || JavadocTagInfo.LINKPLAIN.equals((Object)this.mTagInfo) || JavadocTagInfo.THROWS.equals((Object)this.mTagInfo) || JavadocTagInfo.EXCEPTION.equals((Object)this.mTagInfo);
    }
}

