/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.LineSeparatorOption;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.apache.commons.beanutils.ConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewlineAtEndOfFileCheck
extends AbstractFileSetCheck {
    private LineSeparatorOption mLineSeparator = LineSeparatorOption.SYSTEM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processFiltered(File aFile, List<String> aLines) {
        RandomAccessFile randomAccessFile;
        block4: {
            randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(aFile, "r");
                if (this.endsWithNewline(randomAccessFile)) break block4;
                this.log(0, "noNewlineAtEOF", aFile.getPath());
            }
            catch (IOException e) {
                try {
                    this.log(0, "unable.open", aFile.getPath());
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(randomAccessFile);
                    throw throwable;
                }
                Utils.closeQuietly(randomAccessFile);
            }
        }
        Utils.closeQuietly(randomAccessFile);
    }

    public void setLineSeparator(String aLineSeparator) {
        try {
            this.mLineSeparator = Enum.valueOf(LineSeparatorOption.class, aLineSeparator.trim().toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new ConversionException("unable to parse " + aLineSeparator, (Throwable)iae);
        }
    }

    private boolean endsWithNewline(RandomAccessFile aRandomAccessFile) throws IOException {
        int len = this.mLineSeparator.length();
        if (aRandomAccessFile.length() < (long)len) {
            return false;
        }
        aRandomAccessFile.seek(aRandomAccessFile.length() - (long)len);
        byte[] lastBytes = new byte[len];
        int readBytes = aRandomAccessFile.read(lastBytes);
        if (readBytes != len) {
            throw new IOException("Unable to read " + len + " bytes, got " + readBytes);
        }
        return this.mLineSeparator.matches(lastBytes);
    }
}

