/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.util.Service;

public class UnifiedRules {
    private static final String fname = "allRules.txt";
    private static final String path = "/oracle/jdbc/driver/parser/";

    public static Set<RuleTuple> getRules(URL url) throws Exception {
        InputStream is = url.openStream();
        TreeSet<RuleTuple> rules = new TreeSet<RuleTuple>();
        StringTokenizer st = new StringTokenizer(Service.readFile(is), "\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            token = token.trim();
            int colonPos = token.indexOf(": ");
            String head = token.substring(0, colonPos);
            StringTokenizer st1 = new StringTokenizer(token.substring(colonPos + ": ".length()), " ");
            LinkedList<String> rhs = new LinkedList<String>();
            while (st1.hasMoreTokens()) {
                rhs.add(st1.nextToken());
            }
            rules.add(new RuleTuple(head, rhs));
        }
        is.close();
        return rules;
    }

    public static Set<RuleTuple> getRules() throws Exception {
        Set<RuleTuple> sqlRules = UnifiedRules.getSQLRules();
        return sqlRules;
    }

    public static Set<RuleTuple> getSQLRules() throws Exception {
        Class<UnifiedRules> refClass = UnifiedRules.class;
        URL u = refClass.getResource("/oracle/jdbc/driver/parser/allRules.txt");
        return UnifiedRules.getRules(u);
    }
}

