/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSCMYKColor;
import com.openhtmltopdf.css.parser.FSColor;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.value.FontSpecification;
import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.OutputDeviceGraphicsDrawer;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.FontResolverHelper;
import com.openhtmltopdf.pdfboxout.DOMUtil;
import com.openhtmltopdf.pdfboxout.PagePosition;
import com.openhtmltopdf.pdfboxout.PdfBoxAccessibilityHelper;
import com.openhtmltopdf.pdfboxout.PdfBoxBookmarkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFastLinkManager;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxImage;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxPerDocumentFormState;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElement;
import com.openhtmltopdf.pdfboxout.PdfBoxSlowOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.AbstractOutputDevice;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.InlineLayoutBox;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.util.ArrayUtil;
import com.openhtmltopdf.util.XRLog;
import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DFontTextDrawer;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DFontTextDrawer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.JPEGFactory;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PdfBoxFastOutputDevice
extends AbstractOutputDevice
implements OutputDevice,
PdfBoxOutputDevice {
    private static final AffineTransform IDENTITY = new AffineTransform();
    private static final BasicStroke STROKE_ONE = new BasicStroke(1.0f);
    private static final boolean ROUND_RECT_DIMENSIONS_DOWN = false;
    private PDPage _page;
    private PdfContentStreamAdapter _cp;
    private float _pageHeight;
    private PdfBoxFSFont _font;
    private AffineTransform _transform = new AffineTransform();
    private final PageState _desiredPageState = new PageState();
    private final Deque<PageState> _pageStateStack = new ArrayDeque<PageState>();
    private Stroke _stroke = null;
    private Stroke _originalStroke = null;
    private Stroke _oldStroke = null;
    private Area _clip;
    private SharedContext _sharedContext;
    private float _dotsPerPoint;
    private PDDocument _writer;
    private PdfBoxBookmarkManager _bmManager;
    private final List<PdfBoxSlowOutputDevice.Metadata> _metadata = new ArrayList<PdfBoxSlowOutputDevice.Metadata>();
    private final PdfBoxPerDocumentFormState _formState = new PdfBoxPerDocumentFormState();
    private Box _root;
    private int _startPageNo;
    private final boolean _testMode;
    private PdfBoxFastLinkManager _linkManager;
    private RenderingContext _renderingContext;
    private BidiReorderer _reorderer = new SimpleBidiReorderer();
    private PdfBoxGraphics2DFontTextDrawer _fontTextDrawer;
    private PdfBoxAccessibilityHelper _pdfUa;
    private final boolean _pdfUaConform;
    private final boolean _pdfAConform;

    public PdfBoxFastOutputDevice(float dotsPerPoint, boolean testMode, boolean pdfUaConform, boolean pdfAConform) {
        this._dotsPerPoint = dotsPerPoint;
        this._testMode = testMode;
        this._pdfUaConform = pdfUaConform;
        this._pdfAConform = pdfAConform;
    }

    @Override
    public void setWriter(PDDocument writer) {
        this._writer = writer;
    }

    @Override
    public PDDocument getWriter() {
        return this._writer;
    }

    @Override
    public void initializePage(PDPageContentStream currentPage, PDPage page, float height) {
        this._cp = new PdfContentStreamAdapter(currentPage);
        this._page = page;
        this._pageHeight = height;
        this._desiredPageState.fillColor = null;
        this._desiredPageState.strokeColor = null;
        this.pushState(new PageState());
        this._transform = new AffineTransform();
        this._transform.scale(1.0 / (double)this._dotsPerPoint, 1.0 / (double)this._dotsPerPoint);
        this._originalStroke = this._stroke = this.transformStroke(STROKE_ONE);
        this._oldStroke = this._stroke;
        this.setStrokeDiff(this._stroke, null);
        if (this._pdfUa != null) {
            this._pdfUa.startPage(this._page, this._cp, this._renderingContext, this._pageHeight, this._transform);
        }
    }

    private PageState currentState() {
        return this._pageStateStack.peekFirst();
    }

    private void pushState(PageState state) {
        this._pageStateStack.addFirst(state);
    }

    private PageState popState() {
        return this._pageStateStack.removeFirst();
    }

    @Override
    public void finishPage() {
        this._cp.closeContent();
        this.popState();
        if (this._pdfUa != null) {
            this._pdfUa.endPage();
        }
    }

    @Override
    public void paintReplacedElement(RenderingContext c, BlockBox box) {
        PdfBoxReplacedElement element = (PdfBoxReplacedElement)box.getReplacedElement();
        element.paint(c, this, box);
    }

    @Override
    public void paintBackground(RenderingContext c, Box box) {
        super.paintBackground(c, box);
        this._linkManager.processLinkLater(c, box, this._page, this._pageHeight, this._transform);
        if (box.getElement() != null && box.getElement().getNodeName().equals("form")) {
            this._formState.addFormIfRequired(box, this);
        } else if (box.getElement() != null && ArrayUtil.isOneOf((Object)box.getElement().getNodeName(), (Object[])new String[]{"input", "textarea", "button", "select", "openhtmltopdf-combo"})) {
            this._formState.addControlIfRequired(box, this._page, this._transform, c, this._pageHeight);
        }
    }

    private void processControls() {
        this._formState.processControls(this._sharedContext, this._writer, this._root);
    }

    @Override
    public float getDeviceLength(float length) {
        return length / this._dotsPerPoint;
    }

    @Override
    public void drawBorderLine(Shape bounds, int side, int lineWidth, boolean solid) {
        this.draw(bounds);
    }

    @Override
    public void setColor(FSColor color) {
        if (color instanceof FSRGBColor) {
            this._desiredPageState.fillColor = color;
            this._desiredPageState.strokeColor = color;
        } else if (color instanceof FSCMYKColor) {
            this._desiredPageState.fillColor = color;
            this._desiredPageState.strokeColor = color;
        } else assert (color instanceof FSRGBColor || color instanceof FSCMYKColor);
    }

    @Override
    public void draw(Shape s) {
        this.followPath(s, GraphicsOperation.STROKE);
    }

    protected void drawLine(int x1, int y1, int x2, int y2) {
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        this.draw(line);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.draw(oval);
    }

    @Override
    public void fill(Shape s) {
        this.followPath(s, GraphicsOperation.FILL);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        Ellipse2D.Float oval = new Ellipse2D.Float(x, y, width, height);
        this.fill(oval);
    }

    @Override
    public void translate(double tx, double ty) {
        this._transform.translate(tx, ty);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object value) {
    }

    @Override
    public void setFont(FSFont font) {
        this._font = (PdfBoxFSFont)font;
    }

    private AffineTransform normalizeMatrix(AffineTransform current) {
        double[] mx = new double[6];
        AffineTransform result = new AffineTransform();
        result.getMatrix(mx);
        mx[3] = -1.0;
        mx[5] = this._pageHeight;
        result = new AffineTransform(mx);
        result.concatenate(current);
        return result;
    }

    @Override
    public void drawString(String s, float x, float y, JustificationInfo info) {
        PDFont firstFont = this._font.getFontDescription().get(0).getFont();
        try {
            firstFont.getStringWidth(s);
            this.drawStringFast(s, x, y, info, this._font.getFontDescription().get(0), this._font.getSize2D());
            return;
        }
        catch (Exception exception) {
            List<PdfBoxSlowOutputDevice.FontRun> fontRuns = PdfBoxTextRenderer.divideIntoFontRuns(this._font, s, this._reorderer);
            float xOffset = 0.0f;
            for (PdfBoxSlowOutputDevice.FontRun run : fontRuns) {
                this.drawStringFast(run.str, x + xOffset, y, info, run.des, this._font.getSize2D());
                try {
                    if (info == null) {
                        xOffset += run.des.getFont().getStringWidth(run.str) / 1000.0f * this._font.getSize2D();
                        continue;
                    }
                    xOffset += run.des.getFont().getStringWidth(run.str) / 1000.0f * this._font.getSize2D() + (float)run.spaceCharacterCount * info.getSpaceAdjust() + (float)run.otherCharacterCount * info.getNonSpaceAdjust();
                }
                catch (Exception e) {
                    XRLog.render((Level)Level.WARNING, (String)"BUG. Font didn't contain expected character.", (Throwable)e);
                }
            }
            return;
        }
    }

    @Override
    public void drawStringFast(String s, float x, float y, JustificationInfo info, PdfBoxFontResolver.FontDescription desc, float fontSize) {
        if (s.length() == 0) {
            return;
        }
        this.ensureFillColor();
        AffineTransform at = new AffineTransform(this.getTransform());
        at.translate(x, y);
        AffineTransform inverse = this.normalizeMatrix(at);
        AffineTransform flipper = AffineTransform.getScaleInstance(1.0, -1.0);
        inverse.concatenate(flipper);
        inverse.scale(this._dotsPerPoint, this._dotsPerPoint);
        double[] mx = new double[6];
        inverse.getMatrix(mx);
        float b = (float)mx[1];
        float c = (float)mx[2];
        fontSize /= this._dotsPerPoint;
        boolean resetMode = false;
        FontSpecification fontSpec = this.getFontSpecification();
        if (fontSpec != null) {
            int have;
            int need = FontResolverHelper.convertWeightToInt((IdentValue)fontSpec.fontWeight);
            if (need > (have = desc.getWeight())) {
                this._cp.setRenderingMode(RenderingMode.FILL_STROKE);
                float lineWidth = fontSize * 0.04f;
                this._cp.setLineWidth(lineWidth);
                resetMode = true;
                this.ensureStrokeColor();
            }
            if (fontSpec.fontStyle == IdentValue.ITALIC && desc.getStyle() != IdentValue.ITALIC) {
                b = 0.0f;
                c = 0.21256f;
            }
        }
        this._cp.beginText();
        this._cp.setFont(desc.getFont(), fontSize);
        this._cp.setTextMatrix((float)mx[0], b, c, (float)mx[3], (float)mx[4], (float)mx[5]);
        if (info != null) {
            Object[] array = this.makeJustificationArray(s, info);
            this._cp.drawStringWithPositioning(array);
        } else {
            this._cp.drawString(s);
        }
        this._cp.endText();
        if (resetMode) {
            this._cp.setRenderingMode(RenderingMode.FILL);
            this._cp.setLineWidth(1.0f);
        }
    }

    private Object[] makeJustificationArray(String s, JustificationInfo info) {
        ArrayList<Object> data = new ArrayList<Object>(s.length() * 2);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            data.add(Character.toString(c));
            if (i == len - 1) continue;
            float offset = c == ' ' || c == '\u00a0' || c == '\u3000' ? info.getSpaceAdjust() : info.getNonSpaceAdjust();
            data.add(Float.valueOf(-offset / this._dotsPerPoint * 1000.0f / (this._font.getSize2D() / this._dotsPerPoint)));
        }
        return data.toArray();
    }

    private AffineTransform getTransform() {
        return this._transform;
    }

    private void ensureFillColor() {
        PageState state = this.currentState();
        if (state.fillColor == null || !state.fillColor.equals(this._desiredPageState.fillColor)) {
            state.fillColor = this._desiredPageState.fillColor;
            if (state.fillColor instanceof FSRGBColor) {
                FSRGBColor rgb = (FSRGBColor)state.fillColor;
                this._cp.setFillColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            } else if (state.fillColor instanceof FSCMYKColor) {
                FSCMYKColor cmyk = (FSCMYKColor)state.fillColor;
                this._cp.setFillColor(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
            } else assert (state.fillColor instanceof FSRGBColor || state.fillColor instanceof FSCMYKColor);
        }
    }

    private void ensureStrokeColor() {
        PageState state = this.currentState();
        if (state.strokeColor == null || !state.strokeColor.equals(this._desiredPageState.strokeColor)) {
            state.strokeColor = this._desiredPageState.strokeColor;
            if (state.strokeColor instanceof FSRGBColor) {
                FSRGBColor rgb = (FSRGBColor)state.strokeColor;
                this._cp.setStrokingColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue());
            } else if (state.strokeColor instanceof FSCMYKColor) {
                FSCMYKColor cmyk = (FSCMYKColor)state.strokeColor;
                this._cp.setStrokingColor(cmyk.getCyan(), cmyk.getMagenta(), cmyk.getYellow(), cmyk.getBlack());
            } else assert (state.strokeColor instanceof FSRGBColor || state.strokeColor instanceof FSCMYKColor);
        }
    }

    @Override
    public PdfContentStreamAdapter getCurrentPage() {
        return this._cp;
    }

    @Override
    public PDPage getPage() {
        return this._page;
    }

    private void followPath(Shape s, GraphicsOperation drawType) {
        if (s == null) {
            return;
        }
        if (drawType == GraphicsOperation.STROKE && !(this._stroke instanceof BasicStroke)) {
            s = this._stroke.createStrokedShape(s);
            this.followPath(s, GraphicsOperation.FILL);
            return;
        }
        if (drawType == GraphicsOperation.STROKE) {
            this.setStrokeDiff(this._stroke, this._oldStroke);
            this._oldStroke = this._stroke;
            this.ensureStrokeColor();
        } else if (drawType == GraphicsOperation.FILL) {
            this.ensureFillColor();
        }
        PathIterator points = drawType == GraphicsOperation.CLIP ? s.getPathIterator(IDENTITY) : s.getPathIterator(this._transform);
        float[] coords = new float[6];
        int traces = 0;
        while (!points.isDone()) {
            ++traces;
            int segtype = points.currentSegment(coords);
            this.normalizeY(coords);
            switch (segtype) {
                case 4: {
                    this._cp.closeSubpath();
                    break;
                }
                case 3: {
                    this._cp.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    this._cp.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    this._cp.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this._cp.curveTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            points.next();
        }
        switch (drawType) {
            case FILL: {
                if (traces <= 0) break;
                if (points.getWindingRule() == 0) {
                    this._cp.fillEvenOdd();
                    break;
                }
                this._cp.fillNonZero();
                break;
            }
            case STROKE: {
                if (traces <= 0) break;
                this._cp.stroke();
                break;
            }
            default: {
                if (traces == 0) {
                    this._cp.addRect(0.0f, 0.0f, 0.0f, 0.0f);
                }
                if (points.getWindingRule() == 0) {
                    this._cp.clipEvenOdd();
                } else {
                    this._cp.clipNonZero();
                }
                this._cp.newPath();
            }
        }
    }

    private float normalizeY(float y) {
        return this._pageHeight - y;
    }

    @Override
    public float normalizeY(float y, float pageHeight) {
        return pageHeight - y;
    }

    private void normalizeY(float[] coords) {
        coords[1] = this.normalizeY(coords[1]);
        coords[3] = this.normalizeY(coords[3]);
        coords[5] = this.normalizeY(coords[5]);
    }

    private void setStrokeDiff(Stroke newStroke, Stroke oldStroke) {
        if (newStroke == oldStroke) {
            return;
        }
        if (!(newStroke instanceof BasicStroke)) {
            return;
        }
        BasicStroke nStroke = (BasicStroke)newStroke;
        boolean oldOk = oldStroke instanceof BasicStroke;
        BasicStroke oStroke = null;
        if (oldOk) {
            oStroke = (BasicStroke)oldStroke;
        }
        if (!oldOk || nStroke.getLineWidth() != oStroke.getLineWidth()) {
            this._cp.setLineWidth(nStroke.getLineWidth());
        }
        if (!oldOk || nStroke.getEndCap() != oStroke.getEndCap()) {
            switch (nStroke.getEndCap()) {
                case 0: {
                    this._cp.setLineCap(0);
                    break;
                }
                case 2: {
                    this._cp.setLineCap(2);
                    break;
                }
                default: {
                    this._cp.setLineCap(1);
                }
            }
        }
        if (!oldOk || nStroke.getLineJoin() != oStroke.getLineJoin()) {
            switch (nStroke.getLineJoin()) {
                case 0: {
                    this._cp.setLineJoin(0);
                    break;
                }
                case 2: {
                    this._cp.setLineJoin(2);
                    break;
                }
                default: {
                    this._cp.setLineJoin(1);
                }
            }
        }
        if (!oldOk || nStroke.getMiterLimit() != oStroke.getMiterLimit()) {
            this._cp.setMiterLimit(nStroke.getMiterLimit());
        }
        boolean makeDash = oldOk ? (nStroke.getDashArray() != null ? (nStroke.getDashPhase() != oStroke.getDashPhase() ? true : !Arrays.equals(nStroke.getDashArray(), oStroke.getDashArray())) : oStroke.getDashArray() != null) : true;
        if (makeDash) {
            float[] dash = nStroke.getDashArray();
            if (dash == null) {
                this._cp.setLineDash(new float[0], 0.0f);
            } else {
                this._cp.setLineDash(dash, nStroke.getDashPhase());
            }
        }
    }

    @Override
    public void setStroke(Stroke s) {
        this._originalStroke = s;
        this._stroke = this.transformStroke(s);
    }

    private Stroke transformStroke(Stroke stroke) {
        if (!(stroke instanceof BasicStroke)) {
            return stroke;
        }
        BasicStroke st = (BasicStroke)stroke;
        float scale = (float)Math.sqrt(Math.abs(this._transform.getDeterminant()));
        float[] dash = st.getDashArray();
        if (dash != null) {
            int k = 0;
            while (k < dash.length) {
                int n = k++;
                dash[n] = dash[n] * scale;
            }
        }
        return new BasicStroke(st.getLineWidth() * scale, st.getEndCap(), st.getLineJoin(), st.getMiterLimit(), dash, st.getDashPhase() * scale);
    }

    @Override
    public void clip(Shape s) {
        if (this.isFastRenderer()) {
            XRLog.render((Level)Level.SEVERE, (String)"clip MUST not be used by the fast renderer. Please consider reporting this bug.");
            return;
        }
        if (s != null) {
            s = this._transform.createTransformedShape(s);
            if (this._clip == null) {
                this._clip = new Area(s);
            } else {
                this._clip.intersect(new Area(s));
            }
            this.followPath(s, GraphicsOperation.CLIP);
        } else assert (s != null);
    }

    @Override
    public Shape getClip() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void popClip() {
        this._cp.restoreGraphics();
        this.popState();
        this.clearPageState();
    }

    @Override
    public void pushClip(Shape s) {
        this._cp.saveGraphics();
        this.pushState(this.currentState().copy());
        if (s != null) {
            Shape s1 = this._transform.createTransformedShape(s);
            this.followPath(s1, GraphicsOperation.CLIP);
        }
    }

    @Override
    public void setClip(Shape s) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stroke getStroke() {
        return this._originalStroke;
    }

    @Override
    public void realizeImage(PdfBoxImage img) {
        PDImageXObject xobject;
        try {
            if (img.isJpeg()) {
                xobject = JPEGFactory.createFromStream((PDDocument)this._writer, (InputStream)new ByteArrayInputStream(img.getBytes()));
            } else {
                BufferedImage buffered = ImageIO.read(new ByteArrayInputStream(img.getBytes()));
                xobject = LosslessFactory.createFromImage((PDDocument)this._writer, (BufferedImage)buffered);
            }
        }
        catch (IOException e) {
            throw new PdfContentStreamAdapter.PdfException("realizeImage", e);
        }
        img.clearBytes();
        img.setXObject(xobject);
    }

    @Override
    public void drawImage(FSImage fsImage, int x, int y, boolean interpolate) {
        PdfBoxImage img = (PdfBoxImage)fsImage;
        PDImageXObject xobject = img.getXObject();
        if (interpolate) {
            if (!this._pdfAConform) {
                xobject.setInterpolate(true);
            }
        } else {
            try {
                InputStream inputStream = xobject.getStream().getCOSObject().createRawInputStream();
                PDImageXObject cloneImage = new PDImageXObject(this._writer, inputStream, (COSBase)COSName.FLATE_DECODE, xobject.getWidth(), xobject.getHeight(), xobject.getBitsPerComponent(), xobject.getColorSpace());
                cloneImage.setInterpolate(false);
                if (xobject.getSoftMask() != null) {
                    cloneImage.getCOSObject().setItem(COSName.SMASK, (COSObjectable)xobject.getSoftMask());
                }
                inputStream.close();
                xobject = cloneImage;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        AffineTransform transformer = (AffineTransform)this.getTransform().clone();
        transformer.translate(x, y);
        transformer.translate(0.0, img.getHeight());
        AffineTransform normalized = this.normalizeMatrix(transformer);
        normalized.scale(img.getWidth(), -img.getHeight());
        double[] mx = new double[6];
        normalized.getMatrix(mx);
        this._cp.drawImage(xobject, (float)mx[4], (float)mx[5], (float)mx[0], (float)mx[3]);
    }

    @Override
    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    @Override
    public void start(Document doc) {
        this._bmManager = new PdfBoxBookmarkManager(doc, this._writer, this._sharedContext, this._dotsPerPoint, this);
        this._linkManager = new PdfBoxFastLinkManager(this._sharedContext, this._dotsPerPoint, this._root, this);
        this.loadMetadata(doc);
        if (this._pdfUaConform) {
            this._pdfUa = new PdfBoxAccessibilityHelper(this, this._root, doc);
        }
    }

    @Override
    public void finish(RenderingContext c, Box root) {
        if (this._pdfUa != null) {
            this._pdfUa.finishPdfUa();
        }
        this._bmManager.loadBookmarks();
        this._bmManager.writeOutline(c, root);
        this.processControls();
        this._linkManager.processLinks(this._pdfUa);
        if (this._pdfUa != null) {
            this._pdfUa.finishNumberTree();
        }
    }

    @Override
    public int getPageRefY(Box box) {
        if (box instanceof InlineLayoutBox) {
            InlineLayoutBox iB = (InlineLayoutBox)box;
            return iB.getAbsY() + iB.getBaseline();
        }
        return box.getAbsY();
    }

    @Override
    public void addMetadata(String name, String value) {
        if (name != null && value != null) {
            PdfBoxSlowOutputDevice.Metadata m = new PdfBoxSlowOutputDevice.Metadata(name, value);
            this._metadata.add(m);
        }
    }

    @Override
    public String getMetadataByName(String name) {
        if (name != null) {
            for (PdfBoxSlowOutputDevice.Metadata m : this._metadata) {
                if (m == null || !m.getName().equalsIgnoreCase(name)) continue;
                return m.getContent();
            }
        }
        return null;
    }

    @Override
    public List<String> getMetadataListByName(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (name != null) {
            for (PdfBoxSlowOutputDevice.Metadata m : this._metadata) {
                if (m == null || !m.getName().equalsIgnoreCase(name)) continue;
                result.add(m.getContent());
            }
        }
        return result;
    }

    private void loadMetadata(Document doc) {
        Element head = DOMUtil.getChild(doc.getDocumentElement(), "head");
        if (head != null) {
            Element t;
            String title;
            List<Element> l = DOMUtil.getChildren(head, "meta");
            if (l != null) {
                for (Element e : l) {
                    String name = e.getAttribute("name");
                    if (name == null) continue;
                    String content = e.getAttribute("content");
                    PdfBoxSlowOutputDevice.Metadata m = new PdfBoxSlowOutputDevice.Metadata(name, content);
                    this._metadata.add(m);
                }
            }
            if ((title = this.getMetadataByName("title")) == null && (t = DOMUtil.getChild(head, "title")) != null) {
                title = DOMUtil.getText(t).trim();
                PdfBoxSlowOutputDevice.Metadata m = new PdfBoxSlowOutputDevice.Metadata("title", title);
                this._metadata.add(m);
            }
        }
    }

    @Override
    public void setMetadata(String name, String value) {
        if (name != null) {
            boolean remove = value == null;
            int free = -1;
            int len = this._metadata.size();
            for (int i = 0; i < len; ++i) {
                PdfBoxSlowOutputDevice.Metadata m = this._metadata.get(i);
                if (m != null) {
                    if (!m.getName().equalsIgnoreCase(name)) continue;
                    if (!remove) {
                        remove = true;
                        m.setContent(value);
                        continue;
                    }
                    this._metadata.set(i, null);
                    continue;
                }
                if (free != -1) continue;
                free = i;
            }
            if (!remove) {
                PdfBoxSlowOutputDevice.Metadata m = new PdfBoxSlowOutputDevice.Metadata(name, value);
                if (free == -1) {
                    this._metadata.add(m);
                } else {
                    this._metadata.set(free, m);
                }
            }
        }
    }

    @Override
    public List<PdfBoxSlowOutputDevice.Metadata> getMetadata() {
        return this._metadata;
    }

    @Override
    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    @Override
    public void setSharedContext(SharedContext sharedContext) {
        this._sharedContext = sharedContext;
        sharedContext.getCss().setSupportCMYKColors(true);
    }

    @Override
    public void setRoot(Box root) {
        this._root = root;
    }

    @Override
    public int getStartPageNo() {
        return this._startPageNo;
    }

    @Override
    public void setStartPageNo(int startPageNo) {
        this._startPageNo = startPageNo;
    }

    @Override
    public void drawSelection(RenderingContext c, InlineText inlineText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSupportsSelection() {
        return false;
    }

    @Override
    public boolean isSupportsCMYKColors() {
        return true;
    }

    @Override
    public void drawWithGraphics(float x, float y, float width, float height, OutputDeviceGraphicsDrawer renderer) {
        try {
            PdfBoxGraphics2D pdfBoxGraphics2D = new PdfBoxGraphics2D(this._writer, (int)width, (int)height);
            if (this._fontTextDrawer == null) {
                this._fontTextDrawer = new PdfBoxGraphics2DFontTextDrawer(){

                    protected PDFont mapFont(Font font, IPdfBoxGraphics2DFontTextDrawer.IFontTextDrawerEnv env) {
                        FontSpecification spec = new FontSpecification();
                        spec.size = font.getSize();
                        spec.families = new String[]{font.getFamily()};
                        spec.fontStyle = IdentValue.NORMAL;
                        spec.fontWeight = IdentValue.NORMAL;
                        spec.variant = IdentValue.NORMAL;
                        if ((font.getStyle() & 1) == 1) {
                            spec.fontWeight = IdentValue.FONT_WEIGHT_700;
                        }
                        if ((font.getStyle() & 2) == 2) {
                            spec.fontStyle = IdentValue.ITALIC;
                        }
                        PdfBoxFSFont fsFont = (PdfBoxFSFont)PdfBoxFastOutputDevice.this.getSharedContext().getFontResolver().resolveFont(PdfBoxFastOutputDevice.this.getSharedContext(), spec);
                        PdfBoxFontResolver.FontDescription fontDescription = fsFont.getFontDescription().get(0);
                        if (fsFont.getFontDescription().size() == 1 && fontDescription.getFont().getName().equals("Times-Roman") && !font.getFamily().equals("Times New Roman")) {
                            return null;
                        }
                        return fontDescription.getFont();
                    }
                };
            }
            pdfBoxGraphics2D.setFontTextDrawer((IPdfBoxGraphics2DFontTextDrawer)this._fontTextDrawer);
            renderer.render((Graphics2D)pdfBoxGraphics2D);
            pdfBoxGraphics2D.dispose();
            PDFormXObject xFormObject = pdfBoxGraphics2D.getXFormObject();
            xFormObject.setMatrix(AffineTransform.getScaleInstance(0.75, 0.75));
            Point2D.Float p = new Point2D.Float(x, y += height * this._dotsPerPoint * 0.75f);
            Point2D.Float pResult = new Point2D.Float();
            this._transform.transform(p, pResult);
            this._cp.placeXForm((float)((Point2D)pResult).getX(), this._pageHeight - (float)((Point2D)pResult).getY(), xFormObject);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while drawing on Graphics2D", e);
        }
    }

    @Override
    public List<PagePosition> findPagePositionsByID(CssContext c, Pattern pattern) {
        Map idMap = this._sharedContext.getIdMap();
        if (idMap == null) {
            return Collections.emptyList();
        }
        ArrayList<PagePosition> result = new ArrayList<PagePosition>();
        for (Map.Entry entry : idMap.entrySet()) {
            Box box;
            PagePosition pos;
            String id = (String)entry.getKey();
            if (!pattern.matcher(id).find() || (pos = this.calcPDFPagePosition(c, id, box = (Box)entry.getValue())) == null) continue;
            result.add(pos);
        }
        Collections.sort(result, new Comparator<PagePosition>(){

            @Override
            public int compare(PagePosition p1, PagePosition p2) {
                return p1.getPageNo() - p2.getPageNo();
            }
        });
        return result;
    }

    private PagePosition calcPDFPagePosition(CssContext c, String id, Box box) {
        PageBox page = this._root.getLayer().getLastPage(c, box);
        if (page == null) {
            return null;
        }
        float x = box.getAbsX() + page.getMarginBorderPadding(c, 1);
        float y = page.getBottom() - (box.getAbsY() + box.getHeight()) + page.getMarginBorderPadding(c, 4);
        PagePosition result = new PagePosition();
        result.setId(id);
        result.setPageNo(page.getPageNo());
        result.setX(x /= this._dotsPerPoint);
        result.setY(y /= this._dotsPerPoint);
        result.setWidth((float)box.getEffectiveWidth() / this._dotsPerPoint);
        result.setHeight((float)box.getHeight() / this._dotsPerPoint);
        return result;
    }

    @Override
    public void setRenderingContext(RenderingContext result) {
        this._renderingContext = result;
    }

    @Override
    public void setBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    @Override
    public void popTransforms(List<AffineTransform> inverse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AffineTransform> pushTransforms(List<AffineTransform> transforms) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getAbsoluteTransformOriginX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getAbsoluteTransformOriginY() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint instanceof Color) {
            Color c = (Color)paint;
            this.setColor((FSColor)new FSRGBColor(c.getRed(), c.getGreen(), c.getBlue()));
        } else {
            XRLog.render((Level)Level.WARNING, (String)("Unknown paint: " + paint.getClass().getCanonicalName()));
        }
    }

    @Override
    public boolean isPDF() {
        return true;
    }

    @Override
    public void close() {
        if (this._fontTextDrawer != null) {
            this._fontTextDrawer.close();
        }
    }

    private AffineTransform normalizeTransform(AffineTransform transform) {
        double[] mx = new double[6];
        transform.getMatrix(mx);
        mx[4] = mx[4] / (double)this._dotsPerPoint;
        mx[5] = mx[5] / (double)this._dotsPerPoint;
        return new AffineTransform(mx);
    }

    @Override
    public void pushTransformLayer(AffineTransform transform) {
        this._cp.saveGraphics();
        this.pushState(this.currentState().copy());
        AffineTransform normalized = this.normalizeTransform(transform);
        this._cp.applyPdfMatrix(normalized);
    }

    @Override
    public void popTransformLayer() {
        this._cp.restoreGraphics();
        this.popState();
        this.clearPageState();
    }

    @Override
    public boolean isFastRenderer() {
        return true;
    }

    private void clearPageState() {
        this._oldStroke = null;
    }

    public Object startStructure(StructureType type, Box box) {
        if (this._pdfUa != null) {
            return this._pdfUa.startStructure(type, box);
        }
        return null;
    }

    public void endStructure(Object token) {
        if (this._pdfUa != null) {
            this._pdfUa.endStructure(token);
        }
    }

    private static class PageState {
        private FSColor fillColor;
        private FSColor strokeColor;

        private PageState() {
        }

        private PageState copy() {
            PageState ret = new PageState();
            ret.fillColor = this.fillColor;
            ret.strokeColor = this.strokeColor;
            return ret;
        }
    }

    private static enum GraphicsOperation {
        FILL,
        STROKE,
        CLIP;

    }
}

