/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty;

import com.jayway.awaitility.Awaitility;
import com.mycila.testing.core.api.TestExecution;
import com.mycila.testing.plugins.jetty.config.Config;
import java.io.File;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.webapp.WebAppContext;
import org.hamcrest.CoreMatchers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerWebappActions {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicBoolean ready = new AtomicBoolean();
    private final AtomicReference<Server> server = new AtomicReference();
    private final AtomicReference<ContextHandlerCollection> contextHandlerCollection = new AtomicReference();
    private final AtomicReference<WebAppContext> webapp = new AtomicReference();

    public void createServer(final TestExecution testExecution, Config config) {
        this.logger.debug("server creation...");
        this.setServer(new Server(config.getServerPort()));
        this.getServer().addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleFailure(LifeCycle event, Throwable cause) {
                testExecution.setThrowable(cause);
            }

            public void lifeCycleStarted(LifeCycle event) {
                ServerWebappActions.this.ready.set(true);
            }
        });
        HandlerCollection handlerCollection = new HandlerCollection();
        this.setContextHandlerCollection(new ContextHandlerCollection());
        handlerCollection.addHandler((Handler)this.getContextHandlerCollection());
        this.getServer().setHandler((Handler)handlerCollection);
        this.logger.debug("server created");
    }

    public void startServer(Config config) throws Exception {
        String serverPortStr = config == null ? "<null>" : Integer.toString(config.getServerPort());
        this.logger.info("server starting on localhost:{}", (Object)serverPortStr);
        if (config != null) {
            config.getServerLifeCycleListener().beforeServerStart(this.getServer());
        }
        this.getServer().start();
        WaitUntilReadyCallable isReady = new WaitUntilReadyCallable(this.ready);
        Awaitility.await().until((Callable)isReady, CoreMatchers.equalTo((Object)true));
        if (config != null) {
            config.getServerLifeCycleListener().afterServerStart(this.getServer());
        }
        this.logger.info("server started");
    }

    public void stopServer(Config config) throws Exception {
        this.logger.info("server stopping");
        if (config != null) {
            config.getServerLifeCycleListener().beforeServerStop(this.getServer());
        }
        this.getContextHandlerCollection().stop();
        this.getServer().stop();
        if (config != null) {
            config.getServerLifeCycleListener().afterServerStop(this.getServer());
        }
        this.logger.info("server stopped");
        this.getServer().destroy();
        this.setContextHandlerCollection(null);
        this.setServer(null);
    }

    public boolean hasServer() {
        return this.getServer() != null;
    }

    public Server getServer() {
        return this.server.get();
    }

    public void setServer(Server server) {
        this.server.set(server);
    }

    private ContextHandlerCollection getContextHandlerCollection() {
        return this.contextHandlerCollection.get();
    }

    private void setContextHandlerCollection(ContextHandlerCollection contextHandlerCollection) {
        this.contextHandlerCollection.set(contextHandlerCollection);
    }

    public void createWebAppContext(Config config) throws URISyntaxException {
        this.logger.debug("webapp creation...");
        File warFile = new File(config.getWarLocationUrl().toURI());
        if (!warFile.exists()) {
            throw new AssertionError((Object)("non-existent WAR : " + warFile.getAbsolutePath()));
        }
        if (!("/".equals(config.getContextPath()) || config.getContextPath().startsWith("/") && !config.getContextPath().endsWith("/"))) {
            throw new AssertionError((Object)"contextPath must starts with a slash '/' but doesn't end with one");
        }
        this.setWebAppContext(new WebAppContext());
        this.getWebAppContext().setWar(config.getWarLocationUrl().getFile());
        this.getWebAppContext().setContextPath(config.getContextPath());
        this.getWebAppContext().setCopyWebDir(false);
        this.getWebAppContext().setExtractWAR(false);
        this.getWebAppContext().setLogUrlOnStart(true);
        this.logger.info("webapp created on localhost:{}{} with WAR:{}", new Object[]{config.getServerPort(), config.getContextPath(), config.getWarLocation()});
    }

    public void startWebApp(Config config) throws Exception {
        this.logger.info("webapp starting");
        if (config != null) {
            config.getServerLifeCycleListener().beforeWebappStart(this.getServer(), this.getWebAppContext());
        }
        this.getContextHandlerCollection().addHandler((Handler)this.getWebAppContext());
        this.getWebAppContext().start();
        if (config != null) {
            config.getServerLifeCycleListener().afterWebappStart(this.getServer(), this.getWebAppContext());
        }
        this.logger.info("webapp started");
    }

    public void stopWebapp(Config config) throws Exception {
        this.logger.info("webapp stopping");
        if (config != null) {
            config.getServerLifeCycleListener().beforeWebappStop(this.getServer(), this.getWebAppContext());
        }
        this.getWebAppContext().stop();
        if (config != null) {
            config.getServerLifeCycleListener().beforeWebappStop(this.getServer(), this.getWebAppContext());
        }
        this.getContextHandlerCollection().removeHandler((Handler)this.getWebAppContext());
        this.getWebAppContext().destroy();
        this.getWebAppContext().setServer(null);
        this.logger.info("webapp stopped");
        this.setWebAppContext(null);
    }

    public boolean hasWebAppContext() {
        return this.getWebAppContext() != null;
    }

    public WebAppContext getWebAppContext() {
        return this.webapp.get();
    }

    public void setWebAppContext(WebAppContext webAppContext) {
        this.webapp.set(webAppContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WaitUntilReadyCallable
    implements Callable<Boolean> {
        private final AtomicBoolean ready;

        public WaitUntilReadyCallable(AtomicBoolean ready) {
            this.ready = ready;
        }

        @Override
        public Boolean call() throws Exception {
            return this.ready.get();
        }
    }
}

