/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.testing.plugins.jetty;

import com.mycila.testing.core.api.TestContext;
import com.mycila.testing.core.api.TestExecution;
import com.mycila.testing.core.plugin.DefaultTestPlugin;
import com.mycila.testing.plugins.jetty.JettyRunWar;
import com.mycila.testing.plugins.jetty.ServerWebappActions;
import com.mycila.testing.plugins.jetty.config.Config;
import com.mycila.testing.plugins.jetty.config.DefaultConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyTestPlugin
extends DefaultTestPlugin {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ServerWebappActions actions = new ServerWebappActions();

    public void beforeTest(TestExecution testExecution) throws Exception {
        if (!DefaultConfig.hasJettyPlugin(testExecution.method())) {
            return;
        }
        Config config = DefaultConfig.configFrom(testExecution.method());
        this.logger.info("jetty-config : " + config);
        if (config.isSkip()) {
            this.logger.debug("skip running webapp with Jetty");
            return;
        }
        if (this.actions.hasWebAppContext() && config.isDeployWebapp()) {
            this.actions.stopWebapp(config);
        }
        if (this.actions.hasServer() && config.isStartServer()) {
            this.actions.stopServer(config);
        }
        if (!this.actions.hasServer()) {
            this.actions.createServer(testExecution, config);
            this.actions.startServer(config);
        } else {
            this.logger.info("start server ? keep server running");
        }
        if (!this.actions.hasWebAppContext()) {
            this.actions.createWebAppContext(config);
            this.actions.startWebApp(config);
        } else {
            this.logger.info("start webapp ? keep webapp running");
        }
    }

    public void afterTest(TestExecution testExecution) throws Exception {
        if (!DefaultConfig.hasJettyPlugin(testExecution.method())) {
            this.logger.debug("skip " + JettyTestPlugin.class + " because there is no " + JettyRunWar.class + " annotation on test class");
            return;
        }
        Config config = DefaultConfig.configFrom(testExecution.method());
        this.logger.info("jetty-config : " + config);
        if (config.isSkip()) {
            this.logger.debug("skip stopping webapp");
            return;
        }
        if (this.actions.hasWebAppContext() && config.isDeployWebapp()) {
            this.actions.stopWebapp(config);
        } else {
            this.logger.info("stop webapp ? keep webapp running");
        }
        if (this.actions.hasServer() && config.isStartServer()) {
            this.actions.stopServer(config);
        } else {
            this.logger.info("stop server ? keep server running");
        }
    }

    public void shutdown(TestContext context) throws Exception {
        this.logger.debug("JVM shutdown");
        if (this.actions.hasWebAppContext()) {
            this.actions.stopWebapp(null);
        }
        if (this.actions.hasServer()) {
            this.actions.stopServer(null);
        }
    }
}

