/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionRequestBuilder;
import com.microsoft.graph.models.WorkbookTable;
import com.microsoft.graph.models.WorkbookTableItemAtParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.WorkbookTableColumnCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableColumnRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableItemAtRequest;
import com.microsoft.graph.requests.WorkbookTableRowCollectionRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableRowRequestBuilder;
import com.microsoft.graph.requests.WorkbookTableSortRequestBuilder;
import com.microsoft.graph.requests.WorkbookWorksheetRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WorkbookTableItemAtRequestBuilder
extends BaseFunctionRequestBuilder<WorkbookTable> {
    public WorkbookTableItemAtRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    public WorkbookTableItemAtRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull WorkbookTableItemAtParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        if (parameters != null) {
            this.functionOptions = parameters.getFunctionOptions();
        }
    }

    @Nonnull
    public WorkbookTableItemAtRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public WorkbookTableItemAtRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        WorkbookTableItemAtRequest request = new WorkbookTableItemAtRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        for (FunctionOption option : this.functionOptions) {
            request.addFunctionOption(option);
        }
        return request;
    }

    @Nonnull
    public WorkbookTableColumnCollectionRequestBuilder columns() {
        return new WorkbookTableColumnCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("columns"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookTableColumnRequestBuilder columns(@Nonnull String id) {
        return new WorkbookTableColumnRequestBuilder(this.getRequestUrlWithAdditionalSegment("columns") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public WorkbookTableRowCollectionRequestBuilder rows() {
        return new WorkbookTableRowCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("rows"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookTableRowRequestBuilder rows(@Nonnull String id) {
        return new WorkbookTableRowRequestBuilder(this.getRequestUrlWithAdditionalSegment("rows") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public WorkbookTableSortRequestBuilder sort() {
        return new WorkbookTableSortRequestBuilder(this.getRequestUrlWithAdditionalSegment("sort"), this.getClient(), null);
    }

    @Nonnull
    public WorkbookWorksheetRequestBuilder worksheet() {
        return new WorkbookWorksheetRequestBuilder(this.getRequestUrlWithAdditionalSegment("worksheet"), this.getClient(), null);
    }
}

