/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.maven.utils;

import com.azure.core.exception.AzureException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class SystemPropertyUtils {
    public static Object injectCommandLineParameter(String prefix, Object obj, @Nonnull Class cls) {
        Object result = obj;
        try {
            if (result == null) {
                try {
                    result = cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new AzureException(String.format("Class %s should have a default constructor for inject properties", cls.getName()));
                }
            }
            List fields = FieldUtils.getAllFieldsList((Class)cls);
            for (Field field : fields) {
                String objValue;
                String propertyValue;
                if (Modifier.isStatic(field.getModifiers()) || !field.getType().equals(String.class) || !StringUtils.isNotBlank((CharSequence)(propertyValue = System.getProperty(String.format("%s.%s", prefix, field.getName())))) || !StringUtils.isBlank((CharSequence)(objValue = (String)FieldUtils.readField((Object)result, (String)field.getName(), (boolean)true)))) continue;
                FieldUtils.writeField((Object)result, (String)field.getName(), (Object)propertyValue, (boolean)true);
            }
        }
        catch (IllegalAccessException ex) {
            throw new AzureException(ex.getMessage());
        }
        return result;
    }
}

