/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v1.identicator.Identicator;
import com.mchange.v1.identicator.IdentityHashCodeIdenticator;
import com.mchange.v2.c3p0.cfg.C3P0Config;
import com.mchange.v2.c3p0.impl.AbstractNewProxyConnection;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.cfg.PropertiesConfig;
import com.mchange.v2.csv.FastCsvUtils;
import com.mchange.v2.csv.MalformedCsvException;
import com.mchange.v2.encounter.EncounterCounter;
import com.mchange.v2.encounter.EncounterUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.log.jdk14logging.ForwardingLogger;
import com.mchange.v2.naming.ReferenceableUtils;
import com.mchange.v2.sql.SqlUtils;
import com.mchange.v2.uid.UidUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.naming.NamingException;

public final class C3P0ImplUtils {
    private static final boolean CONDITIONAL_LONG_TOKENS = false;
    static final MLogger logger = MLog.getLogger(C3P0ImplUtils.class);
    public static final DbAuth NULL_AUTH = new DbAuth(null, null);
    public static final Object[] NOARGS = new Object[0];
    public static final Logger PARENT_LOGGER = new ForwardingLogger(MLog.getLogger((String)"com.mchange.v2.c3p0"), null);
    private static final EncounterCounter ID_TOKEN_COUNTER = C3P0ImplUtils.createEncounterCounter();
    public static final String VMID_PROPKEY = "com.mchange.v2.c3p0.VMID";
    private static final String VMID_PFX;

    private static EncounterCounter createEncounterCounter() {
        return EncounterUtils.syncWrap((EncounterCounter)EncounterUtils.createWeak((Identicator)IdentityHashCodeIdenticator.INSTANCE));
    }

    public static String allocateIdentityToken(Object object) {
        long l;
        if (object == null) {
            return null;
        }
        String string = Integer.toString(System.identityHashCode(object), 16);
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(VMID_PFX);
        if (ID_TOKEN_COUNTER != null && (l = ID_TOKEN_COUNTER.encounter((Object)string)) > 0L) {
            stringBuffer.append(string);
            stringBuffer.append('#');
            stringBuffer.append(l);
        } else {
            stringBuffer.append(string);
        }
        String string2 = stringBuffer.toString().intern();
        return string2;
    }

    public static DbAuth findAuth(Object object) throws SQLException {
        if (object == null) {
            return NULL_AUTH;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
                Method method;
                Class<?> clazz = propertyDescriptor.getPropertyType();
                String string5 = propertyDescriptor.getName();
                if (clazz != String.class || (method = propertyDescriptor.getReadMethod()) == null) continue;
                Object object2 = method.invoke(object, NOARGS);
                String string6 = (String)object2;
                if ("user".equals(string5)) {
                    string = string6;
                    continue;
                }
                if ("password".equals(string5)) {
                    string2 = string6;
                    continue;
                }
                if ("overrideDefaultUser".equals(string5)) {
                    string3 = string6;
                    continue;
                }
                if (!"overrideDefaultPassword".equals(string5)) continue;
                string4 = string6;
            }
            if (string3 != null) {
                return new DbAuth(string3, string4);
            }
            if (string != null) {
                return new DbAuth(string, string2);
            }
            return NULL_AUTH;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "An exception occurred while trying to extract the default authentification info from a bean.", (Throwable)exception);
            }
            throw SqlUtils.toSQLException((Throwable)exception);
        }
    }

    static void resetTxnState(Connection connection, boolean bl, boolean bl2, boolean bl3) throws SQLException {
        if (!bl && !connection.getAutoCommit()) {
            if (!bl2 && !bl3) {
                connection.rollback();
            }
            connection.setAutoCommit(true);
        }
    }

    public static boolean supportsMethod(Object object, String string, Class[] classArray) {
        try {
            return object.getClass().getMethod(string, classArray) != null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException securityException) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "We were denied access in a check of whether " + object + " supports method " + string + ". Prob means external clients have no access, returning false.", (Throwable)securityException);
            }
            return false;
        }
    }

    public static String createUserOverridesAsString(Map map) throws IOException, MalformedCsvException {
        StringWriter stringWriter = new StringWriter();
        for (Object k : map.keySet()) {
            String string = (String)k;
            ((Writer)stringWriter).append(FastCsvUtils.generateQuotedCsvItem((String)string));
            ((Writer)stringWriter).append("\r\n");
            Map map2 = (Map)map.get(string);
            String[] stringArray = new String[2];
            for (Object k2 : map2.keySet()) {
                stringArray[0] = (String)k2;
                stringArray[1] = (String)map2.get(k2);
                ((Writer)stringWriter).append(FastCsvUtils.generateCsvLineQuotedUnterminated((String[])stringArray));
                ((Writer)stringWriter).append("\r\n");
            }
        }
        return ((Object)stringWriter).toString();
    }

    private static Map parseSingleUserMap(String string, BufferedReader bufferedReader, String[] stringArray) throws IOException, MalformedCsvException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        stringArray[0] = null;
        String string2 = FastCsvUtils.csvReadLine((BufferedReader)bufferedReader);
        if (string2 == null) {
            stringArray[0] = null;
            return Collections.EMPTY_MAP;
        }
        do {
            String[] stringArray2 = FastCsvUtils.csvSplitLine((String)string2);
            switch (stringArray2.length) {
                case 2: {
                    hashMap.put(stringArray2[0], stringArray2[1]);
                    break;
                }
                case 1: {
                    stringArray[0] = stringArray2[0];
                    break;
                }
                default: {
                    throw new IOException("Unexpected CSV line in userOverridesAsString ('" + string2 + "'). All line should have 1 or 2 items:\r\n" + string);
                }
            }
        } while (stringArray[0] == null && (string2 = FastCsvUtils.csvReadLine((BufferedReader)bufferedReader)) != null);
        return Collections.unmodifiableMap(hashMap);
    }

    public static Map parseUserOverridesAsString(String string) throws IOException, MalformedCsvException {
        if (string != null) {
            String[] stringArray = new String[1];
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            String string2 = FastCsvUtils.csvReadLine((BufferedReader)bufferedReader);
            if (string2 == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, Map> hashMap = new HashMap<String, Map>();
            String[] stringArray2 = FastCsvUtils.csvSplitLine((String)string2);
            if (stringArray2.length != 1) {
                throw new IOException("Cannot parse userOverridesAsString, one element line naming the user should come before other data:\r\n" + string);
            }
            String string3 = stringArray2[0];
            do {
                Map map = C3P0ImplUtils.parseSingleUserMap(string, bufferedReader, stringArray);
                hashMap.put(string3, map);
            } while ((string3 = stringArray[0]) != null);
            return Collections.unmodifiableMap(hashMap);
        }
        return Collections.EMPTY_MAP;
    }

    public static void runWithContextClassLoaderAndPrivileges(String string, final boolean bl, final Runnable runnable) {
        block7: {
            try {
                class ContextClassLoaderPoolsInitThread
                extends Thread {
                    ContextClassLoaderPoolsInitThread(ClassLoader classLoader) {
                        this.setContextClassLoader(classLoader);
                    }

                    @Override
                    public void run() {
                        C3P0ImplUtils.maybePrivilegedRun(bl, runnable);
                    }
                }
                if ("library".equalsIgnoreCase(string)) {
                    ContextClassLoaderPoolsInitThread contextClassLoaderPoolsInitThread = new ContextClassLoaderPoolsInitThread(C3P0ImplUtils.class.getClassLoader());
                    contextClassLoaderPoolsInitThread.start();
                    contextClassLoaderPoolsInitThread.join();
                } else if ("none".equalsIgnoreCase(string)) {
                    ContextClassLoaderPoolsInitThread contextClassLoaderPoolsInitThread = new ContextClassLoaderPoolsInitThread(null);
                    contextClassLoaderPoolsInitThread.start();
                    contextClassLoaderPoolsInitThread.join();
                } else {
                    if (logger.isLoggable(MLevel.WARNING) && !"caller".equalsIgnoreCase(string)) {
                        logger.log(MLevel.WARNING, "Unknown contextClassLoaderSource: " + string + " -- should be 'caller', 'library', or 'none'. Using default value 'caller'.");
                    }
                    C3P0ImplUtils.maybePrivilegedRun(bl, runnable);
                }
            }
            catch (InterruptedException interruptedException) {
                if (!logger.isLoggable(MLevel.SEVERE)) break block7;
                logger.log(MLevel.SEVERE, "Unexpected interruption while trying to run task with contextClassLoaderSource '" + string + "' and privilege_spawned_threads '" + bl + "'.", (Throwable)interruptedException);
            }
        }
    }

    private static void maybePrivilegedRun(boolean bl, final Runnable runnable) {
        if (bl) {
            PrivilegedAction privilegedAction = new PrivilegedAction(){

                public Object run() {
                    runnable.run();
                    return null;
                }
            };
            AccessController.doPrivileged(privilegedAction);
        } else {
            runnable.run();
        }
    }

    public static void assertCompileTimePresenceOfJdbc4_Jdk17Api(AbstractNewProxyConnection abstractNewProxyConnection) throws SQLException {
        abstractNewProxyConnection.getNetworkTimeout();
    }

    public static void jndiAssertNameIsAcceptable(Object object) throws NamingException {
        ReferenceableUtils.assertAcceptableName((Object)object, (PropertiesConfig)C3P0Config.getMultiPropertiesConfig());
    }

    private C3P0ImplUtils() {
    }

    static {
        String string = C3P0Config.getPropsFileConfigProperty(VMID_PROPKEY);
        VMID_PFX = string == null || (string = string.trim()).equals("") || string.equals("AUTO") ? UidUtils.VM_ID + '|' : (string.equals("NONE") ? "" : string + "|");
    }
}

