/*
 * *##% 
 * vradi-entities
 * Copyright (C) 2009 JurisMarches
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */
/*
 * //TODO configurer l'ide
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jurismarches.vradi.entities;

import org.sharengo.wikitty.FieldType;
import org.sharengo.wikitty.FieldType.TYPE;

/**
 * @author letellier
 */
public enum FieldTypeEnum {
    STRING(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.string", 0, 1),
    TEXT(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.text", 0, 1),
    DATE(FieldType.TYPE.DATE, "vradi.fieldTypeEnum.date", 1, 1),
    DATE_TIME(FieldType.TYPE.DATE, "vradi.fieldTypeEnum.dateTime", 1, 1),
    EMAIL(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.email", 0, 1),
    URL(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.url", 0, 1),
    NUMERIC(FieldType.TYPE.NUMERIC, "vradi.fieldTypeEnum.numeric", 1, 1),
    CURRENCY(FieldType.TYPE.STRING, "vradi.fieldTypeEnum.currency", 0, 1);

    public static final String CURRENCY_TAG_VALUE = "currency";

    protected String TAG_VALUE = "use";
    protected String tagValue;
    protected FieldType type;

    FieldTypeEnum(TYPE type, String tagValue, int min, int max) {
        this.tagValue = tagValue;
        this.type = new FieldType(type, min, max);
        this.type.addTagValue(TAG_VALUE, tagValue);
    }

    public String getTagValue() {
        return tagValue;
    }

    public FieldType getFieldType() {
        FieldType result = new FieldType(type.getType(), type.getLowerBound(), type.getUpperBound());
        result.addTagValue(TAG_VALUE, tagValue);

        return result;
    }

    public boolean isType(FieldType type) {
        return tagValue.equals(type.getTagValue(TAG_VALUE));
    }

    @Override
    public String toString() {
        return getTagValue();
    }

    public static FieldTypeEnum valueOf(FieldType type) {
        FieldTypeEnum e;
        if (FieldTypeEnum.DATE_TIME.isType(type)) {
            e = FieldTypeEnum.DATE_TIME;
        } else if (FieldTypeEnum.DATE.isType(type) || FieldType.TYPE.DATE.equals(type.getType())) {
            e = FieldTypeEnum.DATE;
        } else if (FieldTypeEnum.EMAIL.isType(type)) {
            e = FieldTypeEnum.EMAIL;
        } else if (FieldTypeEnum.CURRENCY.isType(type)) {
            e = FieldTypeEnum.CURRENCY;
        } else if (FieldTypeEnum.NUMERIC.isType(type) || FieldType.TYPE.NUMERIC.equals(type.getType())) {
            e = FieldTypeEnum.NUMERIC;
        } else if (FieldTypeEnum.TEXT.isType(type)) {
            e = FieldTypeEnum.TEXT;
        } else if (FieldTypeEnum.URL.isType(type)) {
            e = FieldTypeEnum.URL;
        } else {
            e = FieldTypeEnum.STRING;
        }
        return e;
    }

    static public Currency getCurrency(String value) {
        if ("vradi.currency.euro".equals(value)) {
            return Currency.EUR;
        } else if ("vradi.currency.usd".equals(value)) {
            return Currency.USD;
        } else if ("vradi.currency.gbp".equals(value)) {
            return Currency.GBP;
        }
        return null;
    }

    public enum Currency {
        EUR("vradi.currency.euro"),
        USD("vradi.currency.usd"),
        GBP("vradi.currency.gbp");

        private String name;

        Currency(String name) {
            this.name = name;
        }

        @Override
        public String toString() {
            return name;
        }
    }

}
