/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamodb.maven.plugin;

import com.jcabi.dynamodb.maven.plugin.AbstractDynamoMojo;
import com.jcabi.dynamodb.maven.plugin.Instances;
import java.io.File;
import java.io.IOException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(threadSafe=true, name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class StartMojo
extends AbstractDynamoMojo {
    @Parameter(required=true)
    private transient File dist;
    @Parameter(required=false)
    private transient File home;

    @Override
    protected void run(Instances instances) throws MojoFailureException {
        if (!this.dist.exists()) {
            throw new MojoFailureException(String.format("DynamoDB Local distribution doesn't exist: %s", this.dist));
        }
        if (!this.dist.isDirectory()) {
            throw new MojoFailureException(String.format("DynamoDB Local distribution is not a directory: %s", this.dist));
        }
        if (this.home == null) {
            this.home = new File(System.getProperty("java.home"));
        }
        if (!this.home.exists()) {
            throw new MojoFailureException(String.format("Java home doesn't exist: %s", this.home));
        }
        try {
            instances.start(this.dist, this.tcpPort(), this.home, this.args());
        }
        catch (IOException ex) {
            throw new MojoFailureException("failed to start DynamoDB Local", (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return "StartMojo(dist=" + this.dist + ", home=" + this.home + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StartMojo)) {
            return false;
        }
        StartMojo other = (StartMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof StartMojo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

