/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client;

import com.influxdb.v3.client.Point;
import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.InfluxDBClientImpl;
import com.influxdb.v3.client.query.QueryOptions;
import com.influxdb.v3.client.write.WriteOptions;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.vector.VectorSchemaRoot;

public interface InfluxDBClient
extends AutoCloseable {
    public void writeRecord(@Nullable String var1);

    public void writeRecord(@Nullable String var1, @Nonnull WriteOptions var2);

    public void writeRecords(@Nonnull List<String> var1);

    public void writeRecords(@Nonnull List<String> var1, @Nonnull WriteOptions var2);

    public void writePoint(@Nullable Point var1);

    public void writePoint(@Nullable Point var1, @Nonnull WriteOptions var2);

    public void writePoints(@Nonnull List<Point> var1);

    public void writePoints(@Nonnull List<Point> var1, @Nonnull WriteOptions var2);

    @Nonnull
    public Stream<Object[]> query(@Nonnull String var1);

    @Nonnull
    public Stream<Object[]> query(@Nonnull String var1, @Nonnull Map<String, Object> var2);

    @Nonnull
    public Stream<Object[]> query(@Nonnull String var1, @Nonnull QueryOptions var2);

    @Nonnull
    public Stream<Object[]> query(@Nonnull String var1, @Nonnull Map<String, Object> var2, @Nonnull QueryOptions var3);

    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String var1);

    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String var1, @Nonnull Map<String, Object> var2);

    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String var1, @Nonnull QueryOptions var2);

    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String var1, @Nonnull Map<String, Object> var2, @Nonnull QueryOptions var3);

    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String var1);

    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String var1, @Nonnull Map<String, Object> var2);

    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String var1, @Nonnull QueryOptions var2);

    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String var1, @Nonnull Map<String, Object> var2, @Nonnull QueryOptions var3);

    @Nonnull
    public static InfluxDBClient getInstance(@Nonnull String host, @Nullable char[] token, @Nullable String database) {
        ClientConfig config = new ClientConfig.Builder().host(host).token(token).database(database).build();
        return InfluxDBClient.getInstance(config);
    }

    @Nonnull
    public static InfluxDBClient getInstance(@Nonnull String host, @Nullable char[] token, @Nullable String database, @Nullable Map<String, String> defaultTags) {
        ClientConfig config = new ClientConfig.Builder().host(host).token(token).database(database).defaultTags(defaultTags).build();
        return InfluxDBClient.getInstance(config);
    }

    @Nonnull
    public static InfluxDBClient getInstance(@Nonnull ClientConfig config) {
        return new InfluxDBClientImpl(config);
    }

    @Nonnull
    public static InfluxDBClient getInstance(@Nonnull String connectionString) {
        try {
            return InfluxDBClient.getInstance(new ClientConfig.Builder().build(connectionString));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Nonnull
    public static InfluxDBClient getInstance() {
        return InfluxDBClient.getInstance(new ClientConfig.Builder().build(System.getenv(), System.getProperties()));
    }
}

