/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.common;

import com.hortonworks.registries.common.SchemaRegistryVersion;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaRegistryServiceInfo {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaRegistryServiceInfo.class);
    private static final SchemaRegistryServiceInfo INSTANCE = new SchemaRegistryServiceInfo(SchemaRegistryServiceInfo.fetchRegistryVersion());
    private SchemaRegistryVersion version;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static SchemaRegistryVersion fetchRegistryVersion() {
        try (InputStream inputStream = SchemaRegistryServiceInfo.class.getResourceAsStream("/registry/VERSION");){
            Properties props = new Properties();
            props.load(inputStream);
            String version = props.getProperty("version", "unknown");
            String revision = props.getProperty("revision", "unknown");
            String timestampProp = props.getProperty("timestamp");
            Long timestamp = timestampProp != null ? Long.valueOf(Long.parseLong(timestampProp)) : null;
            LOG.info("Schema Registry version [{}], revision [{}], timestamp [{}] ", new Object[]{version, revision, timestamp != null ? new Date(timestamp) : null});
            SchemaRegistryVersion schemaRegistryVersion = new SchemaRegistryVersion(version, revision, timestamp);
            return schemaRegistryVersion;
        }
        catch (Exception e) {
            LOG.warn("Error occurred while reading version file", (Throwable)e);
            return SchemaRegistryVersion.UNKNOWN;
        }
    }

    private SchemaRegistryServiceInfo(SchemaRegistryVersion version) {
        this.version = version;
    }

    public SchemaRegistryVersion version() {
        return this.version;
    }

    public static SchemaRegistryServiceInfo get() {
        return INSTANCE;
    }
}

