/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.LabelError;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.nuiton.util.PagerBean;

public class LabelHistoryAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(LabelHistoryAction.class);
    protected List<LabelError> labelErrors;
    protected Date beginDate;
    protected Date endDate;
    protected int page;
    protected PagerBean pager;

    public void prepare() throws Exception {
        String dateEnd;
        String dateBegin = this.getParameter("beginDate");
        if (StringUtils.isNotBlank((CharSequence)dateBegin)) {
            this.beginDate = SgqUtils.parseSgqDate((String)dateBegin);
        }
        if (StringUtils.isNotBlank((CharSequence)(dateEnd = this.getParameter("endDate")))) {
            this.endDate = SgqUtils.parseSgqDate((String)dateEnd);
        }
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public String execute() throws Exception {
        ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
        Pair searchResult = productionService.getHistory(this.beginDate, this.endDate, this.page * 20, 20);
        this.labelErrors = (List)searchResult.getKey();
        long totalCount = (Long)searchResult.getValue();
        this.pager = this.getPager(this.page, 20, totalCount);
        return "success";
    }

    public List<LabelError> getLabelErrors() {
        return this.labelErrors;
    }

    public PagerBean getPager() {
        return this.pager;
    }

    @Action(value="label-history-export", results={@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"historique.csv\""})})
    public String export() throws Exception {
        return "success";
    }

    public InputStream getInputStream() {
        InputStream result;
        block2: {
            ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
            result = null;
            try {
                result = productionService.getHistoryAsCsv(this.beginDate, this.endDate);
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)"Can't get csv stream", (Throwable)ex);
            }
        }
        return result;
    }
}

