/*
 * #%L
 * SGQ :: Web
 * $Id: BackupRunAction.java 364 2013-05-13 14:26:18Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/BackupRunAction.java $
 * %%
 * Copyright (C) 2013 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.InterceptorRef;
import org.apache.struts2.convention.annotation.InterceptorRefs;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.ConfigurationService;
import com.herbocailleau.sgq.web.SgqActionSupport;

@InterceptorRefs({
    @InterceptorRef("defaultStack"),
    @InterceptorRef(value="execAndWait",
        params={"excludeMethods","input"})
})
public class BackupRunAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -8074981655886378100L;

    protected Map<String, String> devices;

    protected String deviceId;

    protected String notificationEmail;

    @Override
    public String input() throws Exception {
        loadData();
        return INPUT;
    }
    
    protected void loadData() {
        try {
            ConfigurationService configurationService = newService(ConfigurationService.class);
            devices = configurationService.getBackupDevices();
        } catch (SgqBusinessException ex) {
            addActionError(ex.getMessage());
        }
    }

    public Map<String, String> getDevices() {
        return devices;
    }

    public String getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getNotificationEmail() {
        return notificationEmail;
    }

    public void setNotificationEmail(String notificationEmail) {
        this.notificationEmail = notificationEmail;
    }

    @Override
    public void validate() {

        if (StringUtils.isEmpty(deviceId)) {
            addActionError("Le choix du péripherique est obligatoire !");
        }

        if (StringUtils.isEmpty(notificationEmail)) {
            addActionError("L'email de notification est obligatoire !");
        } else if (!notificationEmail.toUpperCase().matches("[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,4}")) {
            addActionError("L'email de notification n'est pas valide !");
        }

        if (hasActionErrors()) {
            loadData();
        }
    }

    @Override
    public String execute() throws Exception {
        ConfigurationService configurationService = newService(ConfigurationService.class);
        configurationService.saveBackupOnDevice(deviceId, notificationEmail);
        return SUCCESS;
    }
}
