/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelImportAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(LabelImportAction.class);
    protected Date productionLastImportDate;
    protected Date expeditionLastImportDate;
    protected Date batchMaxEntryDate;
    protected long labelErrorCount;
    protected boolean forceImport;
    protected File file;
    protected String fileFileName;
    protected List<ImportLog> importLogs;
    protected long importedLines;

    public void prepare() throws Exception {
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.batchMaxEntryDate = batchService.getBatchMaxEntryDate();
        if (SgqUtils.daysBetween((Date)this.batchMaxEntryDate, (Date)new Date()) < 5L) {
            this.batchMaxEntryDate = null;
        }
    }

    public String input() throws Exception {
        ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
        this.productionLastImportDate = productionService.getLastImportDate(Zone.ZE);
        this.expeditionLastImportDate = productionService.getLastImportDate(Zone.ZP);
        this.labelErrorCount = productionService.getLabelErrorCount();
        return super.input();
    }

    public Date getProductionStartDate() {
        return this.productionLastImportDate;
    }

    public Date getExpeditionStartDate() {
        return this.expeditionLastImportDate;
    }

    public Date getBatchMaxEntryDate() {
        return this.batchMaxEntryDate;
    }

    public long getLabelErrorCount() {
        return this.labelErrorCount;
    }

    public void setForceImport(boolean forceImport) {
        this.forceImport = forceImport;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public String execute() throws Exception {
        String result = "success";
        if (this.file == null) {
            result = this.input();
        } else if (this.batchMaxEntryDate != null && !this.forceImport) {
            this.addActionError("L'import ne peut \u00eatre r\u00e9alis\u00e9 s'il n'est pas forc\u00e9");
            result = this.input();
        } else {
            ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
            try {
                this.importLogs = productionService.importLabelsFile(this.fileFileName, this.file);
                this.importedLines = 0L;
                for (ImportLog importLog : this.importLogs) {
                    ++this.importedLines;
                }
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import labels file", (Throwable)ex);
                }
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }

    public List<ImportLog> getImportLogs() {
        return this.importLogs;
    }

    public long getImportedLines() {
        return this.importedLines;
    }
}

