<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Référentiel produits</title>
    </head>
    <body>
    	<h1>Référentiel produits</h1>
    	
    	<h2>Produits</h2>

        <shiro:hasPermission name="product:write:refs">
          <form action="<s:url action='product-edit!input' namespace='/admin' />">
            <input type="submit" value="Nouveau produit" />
          </form>
        </shiro:hasPermission>

        <fieldset>
            <legend>Filtre</legend>

            <form action="<s:url action='product-list' namespace='/admin' />">

              <s:actionerror />

              <table class="filter">
                <tr>
                  <th>Nom&thinsp;:</th>
                  <td><input type="text" name="search.name" value="<s:property value="search.name" />" size="40" /></td>
                </tr>
                <tr>
                  <th>Code&thinsp;:</th>
                  <td><input type="text" name="search.code" value="<s:property value="search.code" />" size="40" /></td>
                </tr>
                <tr>
                  <th>Catégorie&thinsp;:</th>
                  <td>
                    <select name="search.category">
                      <option value=""></option>
                      <s:iterator value="productCategories" var="productCategory">
                        <option value="<s:property />"
                        <s:if test="search.category.equals(#productCategory)">
                          selected="selected"
                        </s:if>
                        ><s:property /></option>
                      </s:iterator>
                    </select>
                  </td>
                </tr>
                <tr>
                  <th>Nom latin&thinsp;:</th>
                  <td><input type="text" name="search.latinName" value="<s:property value="search.latinName" />" size="40" /></td>
                </tr>
                <tr>
                  <th>Archive:</th>
                  <td><label>
                    <input type="checkbox" name="search.archived" value="true" <s:if test="search.archived">checked="checked"</s:if> />
                    Inclure les produits archivés</label>
                  </td>
                </tr>
                <tr>
                    <td colspan="2">
                      <table>
                       <tr>
                         <th>Statuts&thinsp;:</th>
                         <th>Analyses&thinsp;:
                         (<label title="Rechercher les produits qui ont au moins un type d'analyse sélectionné (au lieu de tous les types d'analyse sélectionnés par défaut)"
                                ><input type="checkbox" name="search.analyzeTypeOrOperator" value="true" <s:if test="search.analyzeTypeOrOperator">checked="checked"</s:if>/><img src="<s:url value='/img/link_break.png' />" /></label>)</th>
                       </tr>
                       <tr>
                         <td rowspan="5"><select name="search.productStatusId" multiple="multiple" size="7" style="width:250px">
                                <option value=""
                                    <s:if test='search.productStatus.contains(null)'>
                                      selected="selected"
                                    </s:if>
                                    title="&lt;&lt;&lt; Vide &gt;&gt;&gt;"
                                  >&lt;&lt;&lt; Vide &gt;&gt;&gt;</option>
                                <s:iterator value="productStatuses" var="productStatus">
                                  <option value="<s:property value="topiaId" />"
                                    <s:if test="search.productStatus.contains(#productStatus)">
                                      selected="selected"
                                    </s:if>
                                    title="<s:property value="name" />"
                                  ><s:property value="name" /></option>
                                </s:iterator>
                            </select></td>
                          <td rowspan="5"><select name="search.analyzeTypeId" multiple="multiple" size="7" style="width:250px">
                                <option value=""
                                    <s:if test='search.analyzeTypes.contains(null)'>
                                      selected="selected"
                                    </s:if>
                                    title="&lt;&lt;&lt; Vide &gt;&gt;&gt;"
                                  >&lt;&lt;&lt; Vide &gt;&gt;&gt;</option>
                                <s:iterator value="analyzeTypes" var="analyzeType">
                                  <option value="<s:property value="topiaId" />"
                                    <s:if test="search.analyzeTypes.contains(#analyzeType)">
                                      selected="selected"
                                    </s:if>
                                    title="<s:property value="analyzeCategory.name" /> - <s:property value="name" />"
                                  ><s:property value="analyzeCategory.name" /> - <s:property value="name" /></option>
                                </s:iterator>
                            </select>
                          </td>
                        </tr>
                      </table>
                    </td>
                  </tr>
              </table>

              <input type="submit" value="Rechercher" />
            </form>
        </fieldset>

        <s:property value="pager.records" /> produits trouvés:

    	<table class="listing" style="min-width:1400px">
    	   <tr>
    	       <th>Code</th>
    	       <th>Nom</th>
               <th>Catégorie</th>
    	       <th>Nom latin</th>
    	       <th>Famille</th>
    	       <th>Statuts</th>
    	       <th>Analyses</th>
               <th>Contr&ocirc;le</th>
               <th title="Commentaire">Co.</th>
    	   </tr>
    	   <s:iterator value="products" var="product">
    	   	 <tr>
    	       <td>
                 <shiro:hasPermission name="product:write:main">
                   <a href="<s:url action='product-edit!input' namespace='/admin'>
                       <s:param name="productId"><s:property value="topiaId" /></s:param>
                     </s:url>">
                     <s:property value="code" />
                   </a>
                 </shiro:hasPermission>
                 <shiro:lacksPermission name="product:write:main">
                   <s:property value="code" />
                 </shiro:lacksPermission>
               </td>
    	       <td>
                 <shiro:hasPermission name="product:write:main">
                   <a href="<s:url action='product-edit!input' namespace='/admin'>
                     <s:param name="productId"><s:property value="topiaId" /></s:param>
                     </s:url>">
                     <s:property value="name" />
                   </a>
                 </shiro:hasPermission>
                 <shiro:lacksPermission name="product:write:main">
                   <s:property value="name" />
                 </shiro:lacksPermission>
               </td>
               <td><s:property value="category" /></td>
    	       <td><s:property value="latinName" /></td>
    	       <td><s:property value="family" /></td>
    	       <td>
                 <ul>
                    <s:iterator value="productStatus">
                      <li><s:property value="name" /></li>
                    </s:iterator>
                 </ul></td>
    	       <td>
                 <ul>
                    <s:iterator value="analyzeType">
                      <li><s:property value="name" /></li>
                    </s:iterator>
                 </ul>
               </td>
               <td>
                 <s:if test="#product.botanicControl">
                    Botanique
                 </s:if>
                 <s:elseif test="#product.identificationControl">
                    Identification
                 </s:elseif>
               </td>
               <td>
                 <s:if test="#product.comment.length() != 0">
                   <img src="<s:url value='/img/note_edit.png' />" alt="Commentaire"
                        title="<s:property value="comment" />" />
                 </s:if>
               </td>
    	     </tr>
    	   </s:iterator>
    	</table>

        <jsp:include page="../pager.jsp" />

        <a href="<s:url action="product-export" includeParams="get" />">Export CSV</a>
    </body>
</html>
