/*
 * #%L
 * SGQ :: Web
 * $Id: BatchPresentationEditAction.java 427 2013-07-26 12:58:24Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchPresentationEditAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Presentation;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action d'affichage du détail d'une presentation.
 * 
 * @author echatellier
 */
public class BatchPresentationEditAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected DateFormat df = new SimpleDateFormat("dd/MM/yyyy");

    protected String presentationId;

    protected Presentation presentation;
    
    protected String dmesd;

    public void setPresentationId(String presentationId) {
        this.presentationId = presentationId;
    }

    public void setDmesd(String dmesd) {
        this.dmesd = dmesd;
    }

    @Override
    public String input() throws Exception {
        loadData();
        return super.input();
    }
    
    protected void loadData() {
        BatchService batchService = newService(BatchService.class);
        presentation = batchService.getPresentationById(presentationId);
    }

    @Override
    public void validate() {
        if (StringUtils.isNotBlank(dmesd)) {
            if (SgqUtils.isSgqDate(dmesd)) {
                try {
                    df.parse(dmesd);
                } catch (ParseException ex) {
                    addActionError("Format de date invalide (dd/MM/yyyy)");
                }
            } else {
                addActionError("Format de date invalide (dd/MM/yyyy)");
            }
        }
        
        if (hasErrors()) {
            loadData();
        }
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch-view", "batchId", "${presentation.batch.topiaId}"})})
    public String execute() throws Exception {
        BatchService batchService = newService(BatchService.class);
        presentation = batchService.getPresentationById(presentationId);
        if (StringUtils.isNotBlank(dmesd)) {
            presentation.setDmesd(df.parse(dmesd));
        } else {
            presentation.setDmesd(null);
        }
        batchService.updatePresentation(presentation);
        return SUCCESS;
    }

    public Presentation getPresentation() {
        return presentation;
    }
}
