/*
 * #%L
 * SGQ :: Web
 * $Id: SupplierListAction.java 171 2012-10-19 16:52:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/SupplierListAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class SupplierListAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -3534478380625138078L;

    protected int page;

    protected PagerBean pager;

    protected List<Supplier> suppliers;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String execute() throws Exception {

        ReferentialService referentialService = newService(ReferentialService.class);
        suppliers = referentialService.getSuppliers(ITEM_PER_PAGE * page, ITEM_PER_PAGE);
        long totalCount = referentialService.getSuppliersCount();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public List<Supplier> getSuppliers() {
        return suppliers;
    }
    
    public PagerBean getPager() {
        return pager;
    }
}
