<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion des analyses</title>
    </head>
    <body>
        <h1>Gestion des analyses</h1>

		<fieldset>
			<legend>Filtre</legend>
            <form action="<s:url action='analyze-dashboard' namespace='/user' />">
            <table class="filter">
                <tr>
                    <th>Analyse : </th>
                    <td><select name="analyzeTypeId">
                       <option />
                       <s:iterator value="analyzeTypes" var="at">
                          <option value="<s:property value="topiaId" />"
                            <s:if test="#at == analyzeType">
                              selected="selected"
                            </s:if>
                          ><s:property value="analyzeCategory.name" /> - <s:property value="name" /></option>
                       </s:iterator>
                    </select></td>
                </tr>
                <tr>
                    <th>Num&eacute;ro de lots :</th>
                    <td><input type="text" name="batchNumberBegin"
                       <s:if test="batchNumberBegin != 0">value="<s:property value="batchNumberBegin" />"</s:if> /> &agrave;
                    <input type="text" name="batchNumberEnd"
                       <s:if test="batchNumberEnd != 0">value="<s:property value="batchNumberEnd" />"</s:if> /></td>
                </tr>
                <tr>
                    <th>Prestataire :</th>
                    <td><input type="text" name="supplier" value="<s:property value="supplier" />" /></td>
                </tr>
                <tr>
                    <th>Date limite d'envoi : <img src="<s:url value='/img/info.png' />" title="Ne peut s'appliquer que si que si la date limite d'envoi peut-être calculée à partir de la DPMES renseignée sur le lot." /></th>
                    <td><input type="text" name="sentDateBegin" value="<s:property value="sentDateBegin" />" class="sgqdatefield" /> &agrave;
                    <input type="text" name="sentDateEnd" value="<s:property value="sentDateEnd" />" class="sgqdatefield" /></td>
                </tr>
                <tr>
                    <td colspan="2"><input type="submit" value="Filtrer" /></td>
                </tr>
            </table>
            </form>
		</fieldset>

        <h3>Échantillons à préparer:</h3>
        
        <form action="<s:url action="analyze-dashboard" />" onsubmit="return checkSendAndReceiptDates(this);" method="post">
        
            <s:actionerror />

	        <table class="listing">
	            <tr>
	                <th>Lot</th>
	                <th>Plante</th>
	                <th>DPMES</th>
	                <th>Analyse</th>
	                <th>Date limite d'envoi</th>
                    <th>Date d'envoi</th>
                    <th>Date limite de réception</th>
	                <th>Prestataire</th>
	                <th>Fait</th>
	            </tr>

                <s:iterator value="analysisToSend">
                    <tr>
                        <s:hidden name="analyzeIds" value="%{analyze.topiaId}" />
                        <td class="batch"><a href="<s:url action='batch-view' namespace='/user'>
                            <s:param name="batchId"><s:property value="analyze.batch.topiaId" /></s:param>
                        </s:url>"><s:property value="analyze.batch.number" /></a></td>
                        <td class="product"><a href="<s:url action='batch-view' namespace='/user'>
                            <s:param name="batchId"><s:property value="analyze.batch.topiaId" /></s:param>
                        </s:url>"><s:property value="analyze.batch.product.name" /></a></td>
                        <td>
                          <s:if test="analyze.batch.dpmes != null">
                            <s:text name="sgq.web.common.dateformat">
                              <s:param value="analyze.batch.dpmes"/>
                            </s:text>
                          </s:if></td>
                        <td class="analyze"><s:property value="analyze.analyzeType.analyzeCategory.name" /> - <s:property value="analyze.analyzeType.name" /></td>
                        <td>
                          <s:if test="computedSendLimitDate != null">
                            <s:text name="sgq.web.common.dateformat">
                              <s:param value="computedSendLimitDate"/>
                            </s:text>
                          </s:if></td>
                        <td><input type="text" name="sentDate.<s:property value="analyze.topiaId" />" value="<s:text name="sgq.web.common.dateformat">
                          <s:param value="now"/>
                        </s:text>" size="10" class="sgqdatefield"
                            onchange='updateReceiptDate(this.form["sentDate.<s:property value="analyze.topiaId" />"], this.form["receiveDate.<s:property value="analyze.topiaId" />"], <s:property value="analyze.analyzeType.durationDays" />)' /></td>
                        <td><input type="text" name="receiveDate.<s:property value="analyze.topiaId" />" value="<s:text name="sgq.web.common.dateformat">
                          <s:param value="computedReceiptLimitDate"/>
                        </s:text>" size="10" class="sgqdatefield"/></td>
                        <td>
                            <select name="supplier.<s:property value="analyze.topiaId" />">
                            <option></option>
                            <optgroup label="Laboratoires">
                            <s:iterator value="suppliers" var="supplier">
                                <option value="<s:property value="topiaId" />"
                                  <s:if test="#supplier.equals(analyze.supplier)">
                                    selected="selected"
                                  </s:if>
                                ><s:property value="name" /></option>
                            </s:iterator>
                            </optgroup>

                            <optgroup label="Fournisseurs">
                                <option value="<s:property value="analyze.batch.supplier.topiaId" />"
                                  <s:if test="analyze.batch.supplier.equals(analyze.supplier)">
                                    selected="selected"
                                  </s:if>
                                ><s:property value="analyze.batch.supplier.name" /></option>
                            </optgroup>
                            </select>
                        </td>
                        <td><input type="checkbox" name="check.<s:property value="analyze.topiaId" />" value="true" /></td>
                    </tr>
                </s:iterator>
	        </table>
	        <input type="submit" value="Valider l'envoi" />
        </form>

        <h3>Analyses en attente:</h3>

        <table class="listing">
            <tr>
                <th>Lot</th>
                <th>Plante</th>
                <th>DPMES</th>
                <th>Analyse</th>
                <th>Envoyé le</th>
                <th>Date limite de réception</th>
                <th>Prestataire</th>
                <th>Analyse reçue</th>
            </tr>
            <s:iterator value="analysisToReceive">
                <tr>
                    <td><a href="<s:url action='batch-view' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.number" /></a></td>
                    <td><a href="<s:url action='batch-view' namespace='/user'>
                        <s:param name="batchId"><s:property value="batch.topiaId" /></s:param>
                    </s:url>"><s:property value="batch.product.name" /></a></td>
                    <td>
                      <s:if test="batch.dpmes != null">
                        <s:text name="sgq.web.common.dateformat">
                          <s:param value="batch.dpmes"/>
                        </s:text>
                      </s:if></td>
                    <td><s:property value="analyzeType.analyzeCategory.name" /> -
                        <s:property value="analyzeType.name" /></td>
                    <td><s:text name="sgq.web.common.dateformat">
                        <s:param value="sentDate"/>
                      </s:text></td>
                    <td><s:text name="sgq.web.common.dateformat">
                        <s:param value="receiptLimitDate"/>
                      </s:text></td>
                    <td>
                        <s:property value="supplier.name" />
                    </td>
                    <td>
                        <a href="<s:url action='analyze-receipt!input' namespace='/user'>
                            <s:param name="analyzeId"><s:property value="topiaId" /></s:param>
                        </s:url>">
                            Valider la réception
                        </a>
                    </td>
                </tr>
            </s:iterator>
        </table>
    </body>
</html>
