<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012, 2013 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<%@taglib uri="http://shiro.apache.org/tags" prefix="shiro" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Accueil</title>
    </head>
    <body>
    	<h1>Accueil</h1>

    	<p>Bienvenue sur le <strong>S</strong>ystème de <strong>G</strong>estion
    	de la <strong>Q</strong>ualité de l'Herboristerie Cailleau.</p>

        Informations:
        <ul>
          <li>Nombre total de lots intégrés : <strong><s:property value="batchCount" /></strong></li>
          <li>Nombre de lots en service : <strong><s:property value="operatingBatchCount" /></strong></li>
          <li>Dernier lot lot entrée en plante conventionnelle : <strong><s:property value="lastConventionalBatch" /></strong></li>
          <li>Dernier lot lot entrée en plante biologique : <strong><s:property value="lastBiologicalBatch" /></strong></li>
          <li>Date de la dernière étiquette expédition importée dans le SGQ :
            <strong><s:text name="sgq.web.common.dateformat"><s:param value="labelProductionImportDate"/></s:text></strong></li>
          <li>Date de la dernière étiquette fabrication importée dans le SGQ :
            <strong><s:text name="sgq.web.common.dateformat"><s:param value="labelExpeditionImportDate"/></s:text></strong></li>
        </ul>
                
        <hr />

        <shiro:hasPermission name="batch:receive:read">
          <s:if test="daysBetween(batchMaxEntryDate, now) > 5">
            <h2>Importation fichiers</h2>
            <ul>
              <li>Entrée de lots (FIF_REC.dbf)<br />
                La dernière <a href="<s:url action="batch-receive-view" namespace='/user' />" />importation des lots</a>
                est supérieure à 5 jours (<s:text name="sgq.web.common.dateformat">
                    <s:param value="batchMaxEntryDate"/>
                  </s:text>).</li>
            </ul>
          </s:if>
        </shiro:hasPermission>


        <shiro:hasPermission name="label:import">
          <s:if test="daysBetween(labelProductionImportDate, now) > 5 || daysBetween(labelExpeditionImportDate, now) > 5">
            <h2>Importation fichiers</h2>
            <ul>
              <s:if test="daysBetween(labelProductionImportDate, now) > 5">
                <li>Etiquettes de la fabrication (FIF_HIST.txt)<br />
                La dernière importation du <a href="<s:url action="label-import" namespace='/user' />" />fichier étiquette production (FIF_HIST.txt)</a> est supérieure
                à 5 jours (<s:text name="sgq.web.common.dateformat"><s:param value="labelProductionImportDate"/></s:text>).</li>
              </s:if>
              <s:if test="daysBetween(labelExpeditionImportDate, now) > 5">
                <li>Etiquettes de l'expédition (FIC_HIST.txt)<br />
                La dernière importation du <a href="<s:url action="label-import" namespace='/user' />" />fichier étiquette expédition (FIC_HIST.txt)</a> est supérieure
                à 5 jours (<s:text name="sgq.web.common.dateformat"><s:param value="labelExpeditionImportDate"/></s:text>).</li>
              </s:if>
            </ul>
          </s:if>
        </shiro:hasPermission>



        <shiro:hasPermission name="analyze:dashboard">
        
          <s:if test="!batchWithOutputAndPendingAnalysis.empty">
            <h2>Alertes sur analyse</h2>
            <ul>
              <li>Alertes sur sortie externe :
                <ul>      
                  <s:iterator value="batchWithOutputAndPendingAnalysis">
                    <li><a href="<s:url action='batch-view' namespace='/user'>
                            <s:param name="batchId">
                                <s:property value="topiaId" />
                            </s:param>
                        </s:url>">lot <s:property value="number"/></a>
                        </li>
                  </s:iterator>
                </ul>
              </li>
            </ul>
          </s:if>
        </shiro:hasPermission>
        
        <shiro:hasPermission name="analyze:bulletinalert">
          <s:if test="!batchWithBulletinToAsk.empty">
            <h2>Alertes sur analyse</h2>
            <ul>
              <s:if test="!batchWithBulletinToAsk.empty">
                <li>Lot pour lesquels un bulletin a été demandé au fournisseur :
                  <ul>      
                    <s:iterator value="batchWithBulletinToAsk">
                      <li><a href="<s:url action='batch-view' namespace='/user'>
                              <s:param name="batchId">
                                  <s:property value="topiaId" />
                              </s:param>
                          </s:url>">lot <s:property value="number"/> au fournisseur <s:property value="supplier.name" /></a>
                      </li>
                    </s:iterator>
                  </ul>
                </li>
              </s:if>
            </ul>
          </s:if>
        </shiro:hasPermission>
        
        <shiro:hasPermission name="batch:dedicatedclientalert">
          <s:if test="!dedicatedClientExpiredBatch.empty">
            <h2>Alertes sur étiquettes</h2>
            <ul>
              <li>Quantité négative ou nulle sur lots dédiés clients
                <ul>
                  <s:iterator value="dedicatedClientExpiredBatch">
                    <li><a href="<s:url action='batch-view' namespace='/user'>
                          <s:param name="batchId">
                              <s:property value="topiaId" />
                          </s:param>
                      </s:url>">lot <s:property value="number"/></a> : <s:property value="product.name"/> pour <s:property value="dedicatedClient.name"/>
                      </li>
                  </s:iterator>
                </ul>
              </li>
            </ul>
          </s:if>
        </shiro:hasPermission>

        <shiro:hasPermission name="label:error">
          <s:if test="labelErrorCount > 0 || !batchWithLabelAfterExpiration.empty">
            <h2>Alertes sur étiquettes</h2>
            <ul>
              <s:if test="labelErrorCount > 0">
              <li>
                <a href="<s:url action="label-error" namespace='/user' />">Traiter les <s:property value="labelErrorCount" /> erreurs étiquettes en attentes !</a>
              </li>
              </s:if>

              <s:if test="!batchWithLabelAfterExpiration.empty">
                <li>
                  Lots probablement expirés et pour lesquels une étiquette a été émise
                  <ul>
                    <s:iterator value="batchWithLabelAfterExpiration">
                      <li>
                        <a href="<s:url action="label-error" namespace='/user' />">lot <s:property value="number" /></a>
                      </li>
                    </s:iterator>
                  </ul>
                </li>
              </s:if>
            </ul>
          </s:if>
        </shiro:hasPermission>

        <shiro:hasPermission name="batch:write:expired">
          <s:if test="!batchWithMoreSellThanStock.empty">
            <h2>Alertes sur lots</h2>
             <ul>
              <li>Lots pour lesquels les quantités vendues sont supérieures à la quantité entrée
                <ul>
                  <s:iterator value="batchWithMoreSellThanStock">
                    <li><a href="<s:url action='batch-view' namespace='/user'>
                          <s:param name="batchId">
                              <s:property value="topiaId" />
                          </s:param>
                      </s:url>">lot <s:property value="number"/></a>
                    </li>
                  </s:iterator>
                </ul>
              </li>
            </ul>
          </s:if>

          <s:if test="!batchWithNoStock.empty">
            <h2>Alertes suite inventaire</h2>
            <ul>
              <li>Lots pour lesquels l'inventaire n'a pas donné de stock :
                <ul>
                  <s:iterator value="batchWithNoStock">
                    <li><a href="<s:url action='batch-view' namespace='/user'>
                          <s:param name="batchId">
                              <s:property value="topiaId" />
                          </s:param>
                      </s:url>">lot <s:property value="number"/></a>
                      </li>
                  </s:iterator>
                </ul>
              </li>
            </ul>
          </s:if>
        </shiro:hasPermission>
    </body>
</html>
