/*
 * #%L
 * SGQ :: Web
 * $Id: SgqTopiaTransactionFilter.java 36 2012-08-30 16:47:14Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-1.1.1/sgq-web/src/main/java/com/herbocailleau/sgq/web/SgqTopiaTransactionFilter.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web;

import javax.servlet.ServletRequest;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.filter.TopiaTransactionFilter;

import com.herbocailleau.sgq.business.ServiceFactory;

public class SgqTopiaTransactionFilter extends TopiaTransactionFilter {

    @Override
    protected TopiaContext beginTransaction(ServletRequest request)
            throws TopiaRuntimeException {

        TopiaContext rootContext = ServiceFactory.getRootContext();
        TopiaContext transaction = null;
        try {
            transaction = rootContext.beginTransaction();
        } catch (TopiaException e) {
            throw new TopiaRuntimeException(e);
        }
        return transaction;
    }
}
