<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Gestion des analyzes</title>
    </head>
    <body>
        <h1>Gestion des analyses</h1>

        <h3>Analyses <s:property value="analyze.analyzeType.name" /> reçue pour
            le lot <s:property value="analyze.batch.number" /></h3>

        <s:form action='analyzes-receipt' namespace='/user' method="post" enctype="multipart/form-data">
            <s:actionerror />
            <s:hidden name="analyzeId" value="%{analyze.topiaId}" />

            <p>Prestataire : 
            <select name="supplierId">
              <optgroup label="Laboratoires">
              <s:iterator value="suppliers" var="supplier">
                  <option value="<s:property value="topiaId" />"
                    <s:if test="#supplier == analyze.supplier">
                      selected="selected"
                    </s:if>>
                  <s:property value="name" /></option>
              </s:iterator>
              </optgroup>

              <optgroup label="Fournisseurs">
                  <option value="<s:property value="analyze.batch.supplier.topiaId" />"
                    <s:if test="analyze.batch.supplier == analyze.supplier">
                      selected="selected"
                    </s:if>>
                  <s:property value="analyze.batch.supplier.name" /></option>
              </optgroup>
            </select></p>
            
            <p>Date de réception de l'analyse :
                <input type="text" name="receiptDate" value="<s:text name="sgq.web.common.dateformat">
                          <s:param value="now"/>
                        </s:text>" class="sgqdatefield" />
            </p>
                        
	        <strong>Synthèse:</strong>
	        <p>Mention : <select name="mention" class="analysis">
	           <option value="CONFORM" class="conform">Conforme</option>
	           <option value="ACCEPTABLE" class="acceptable">Acceptable</option>
	           <option value="NOT_ACCEPTABLE" class="notacceptable">Non acceptable</option>
	        </select></p>
	        <p><textarea name="synthesis" cols="130" rows="10"></textarea></p>

            <strong>Fichiers d'analyses :</strong>

            <div id="rootAnalyzeFileDiv">
              <div><input type="file" name="files" /></div>
            </div>

            <p><img src="<s:url value='/img/add.png' />" title="Ajouter un nouveau fichier"
                class="clickable" onClick="addFilePart($('#rootAnalyzeFileDiv'))" /></p>

	        <input type="submit" value="Valider" />
        </s:form>
    </body>
</html>
