/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ProductionService;
import com.herbocailleau.sgq.entities.Zone;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LabelsAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    private static final Log log = LogFactory.getLog(LabelsAction.class);
    protected Date productionLastImportDate;
    protected Date expeditionLastImportDate;
    protected File file;
    protected String fileFileName;
    protected List<ImportLog> importLogs;

    public String input() throws Exception {
        ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
        this.productionLastImportDate = productionService.getLastImportDate(Zone.ZE);
        this.expeditionLastImportDate = productionService.getLastImportDate(Zone.ZP);
        return super.input();
    }

    public Date getProductionStartDate() {
        return this.productionLastImportDate;
    }

    public Date getExpeditionStartDate() {
        return this.expeditionLastImportDate;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFileFileName(String fileFileName) {
        this.fileFileName = fileFileName;
    }

    public String execute() throws Exception {
        String result = "success";
        if (this.file == null) {
            result = this.input();
        } else {
            ProductionService productionService = (ProductionService)this.newService(ProductionService.class);
            try {
                this.importLogs = productionService.importLabelsFile(this.fileFileName, this.file);
            }
            catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't import labels file", (Throwable)ex);
                }
                this.addActionError(ex.getMessage());
                result = this.input();
            }
        }
        return result;
    }

    public List<ImportLog> getImportLogs() {
        return this.importLogs;
    }
}

