/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.util.List;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AnalyzesPrepareProcessAction
extends SgqActionSupport {
    private static final long serialVersionUID = 3074255662512738956L;
    protected List<String> batchIds;
    protected ReferentialService referentialService;
    protected BatchService batchService;
    protected Batch batch;

    public void setBatchIds(List<String> batchIds) {
        this.batchIds = batchIds;
    }

    public void validate() {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.batchService = (BatchService)this.newService(BatchService.class);
        if (this.batchIds == null) {
            this.addActionError("Aucun identifiant de lots fournit");
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {
        for (String batchId : this.batchIds) {
            Batch batch = this.batchService.getBatchById(batchId);
            String[] analyzeTypeIds = this.getParameters("analyzeType." + batch.getTopiaId());
            if (analyzeTypeIds == null) continue;
            for (String analyzeTypeId : analyzeTypeIds) {
                AnalyzeType analyzeType = this.referentialService.findAnalyzeTypeById(analyzeTypeId);
                this.batchService.prepareAnalyze(batch, analyzeType);
            }
        }
        return "success";
    }
}

