/*
 * #%L
 * SGQ :: Web
 * $Id: InventoryAction.java 155 2012-10-10 11:05:25Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/InventoryAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.io.InputStream;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class InventoryAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    private static final Log log = LogFactory.getLog(InventoryAction.class);

    protected File file;

    protected List<ImportLog<Batch>> importLogs;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        String result = SUCCESS;
        if (file == null) {
            result = input();
        } else {
            try {
                BatchService batchService = newService(BatchService.class);
                importLogs = batchService.importInventory(file);
            } catch (Exception ex) {
                if (log.isErrorEnabled()) {
                    log.error("Can't import inventory", ex);
                }
                addActionError(ex.getMessage());
                result = input();
            }
        }
        return result;
    }

    public List<ImportLog<Batch>> getImportLogs() {
        return importLogs;
    }

    @Action(value="inventory-export", results= {@Result(type="stream", params={"contentType", "text/csv", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String export() throws Exception {
        return SUCCESS;
    }

    public InputStream getInputStream() {
        BatchService batchService = newService(BatchService.class);
        InputStream result = null;
        try {
            result = batchService.exportInventory();
        } catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't get csv stream", ex);
            }
        }
        return result;
    }

    public String getFilename() {
        return "inventaire.csv";
    }
}
