/*
 * #%L
 * SGQ :: Web
 * $Id: BatchControlDownloadAction.java 90 2012-09-21 14:15:41Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchControlDownloadAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.SgqBusinessException;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de téléchargement du pdf de control identification ou control
 * botanique.
 * 
 * @author echatellier
 */
public class BatchControlDownloadAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 307425532542738956L;

    private static final Log log = LogFactory.getLog(BatchControlDownloadAction.class);

    protected String batchId;

    protected BatchService batchService;

    protected Batch batch;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Override
    @Action(results= {@Result(type="stream", params={"contentType", "application/pdf", "inputName", "inputStream", "contentDisposition", "attachment; filename=\"${filename}\""})})
    public String execute() throws Exception {
        batchService = newService(BatchService.class);
        batch = batchService.getBatchById(batchId);
        return SUCCESS;
    }

    public InputStream getInputStream() {

        File file = batchService.generateControlFile(batch);
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
        } catch (FileNotFoundException ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't generate pdf", ex);
            }
            throw new SgqBusinessException("Can't create input stream", ex);
        }
        return inputStream;
    }

    public String getFilename() {
        String filename = batchService.getControlFilename(batch);
        return filename;
    }
}
