/*
 * #%L
 * SGQ :: Web
 * $Id: BatchAnalyzeEditProcessAction.java 145 2012-10-09 12:44:07Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/user/BatchAnalyzeEditProcessAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.user;

import java.util.Date;

import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Batch;
import com.herbocailleau.sgq.entities.BatchAnalyze;
import com.herbocailleau.sgq.entities.BatchAnalyzeImpl;
import com.herbocailleau.sgq.web.SgqActionSupport;

/**
 * Action de detail d'un lot.
 * Comprenant detail du lot, analyses et presentation.
 * 
 * @author echatellier
 */
public class BatchAnalyzeEditProcessAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3074255662512738956L;

    protected String analyzeTypeId;

    protected String batchId;

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    @Override
    @Action(results={@Result(type="redirectAction", params = {"actionName", "batch", "batchId", "${batchId}"})})
    public String execute() throws Exception {
        
        BatchService batchService = newService(BatchService.class);
        Batch batch = batchService.getBatchById(batchId);
        ReferentialService referentialService = newService(ReferentialService.class);
        AnalyzeType analyzeType = referentialService.findAnalyzeTypeById(analyzeTypeId);
        
        BatchAnalyze analyze = new BatchAnalyzeImpl();
        analyze.setBatch(batch);
        analyze.setAnalyzeType(analyzeType);
        analyze.setCreationDate(new Date());

        batchService.saveAnalyze(analyze);

        return SUCCESS;
    }
}
