/*
 * #%L
 * SGQ :: Web
 * $Id: ProductsImportAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductsImportAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.io.File;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ProductsImportAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -1028769266983390498L;

    private static final Log log = LogFactory.getLog(ProductsImportAction.class);

    protected File file;

    protected List<ImportLog<Product>> importLogs;

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public String execute() throws Exception {
        String result = SUCCESS;
        try {
            ReferentialService referentialService = newService(ReferentialService.class);
            importLogs = referentialService.importProducts(file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error("Can't import product file", ex);
            }
            addActionError(ex.getMessage());
            result = input();
        }
        return result;
    }
    
    public List<ImportLog<Product>> getImportLogs() {
        return importLogs;
    }
}
