/*
 * #%L
 * SGQ :: Web
 * $Id: ProductsAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ProductsAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Product;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ProductsAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = 5564446302091087009L;

    protected int page;

    protected PagerBean pager;

    protected List<Product> products;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String execute() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);
        products = referentialService.getProducts(ITEM_PER_PAGE * page, ITEM_PER_PAGE);
        long totalCount = referentialService.getProductsCount();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public PagerBean getPager() {
        return pager;
    }

    public List<Product> getProducts() {
        return products;
    }
}
