/*
 * #%L
 * SGQ :: Web
 * $Id: ClientsAction.java 151 2012-10-10 09:03:16Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/sgq-ch/tags/sgq-ch-0.4/sgq-web/src/main/java/com/herbocailleau/sgq/web/actions/admin/ClientsAction.java $
 * %%
 * Copyright (C) 2012 Herboristerie Cailleau
 * %%
 * Herboristerie Cailleau - Tous droits réservés
 * #L%
 */

package com.herbocailleau.sgq.web.actions.admin;

import java.util.List;

import org.nuiton.util.PagerBean;

import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.web.SgqActionSupport;

public class ClientsAction extends SgqActionSupport {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4395441064634702753L;

    protected int page;

    protected PagerBean pager;

    protected List<Client> clients;

    public void setPage(int page) {
        this.page = page;
    }

    @Override
    public String execute() throws Exception {
        ReferentialService referentialService = newService(ReferentialService.class);
        clients = referentialService.getClients(ITEM_PER_PAGE  * page, ITEM_PER_PAGE);
        long totalCount = referentialService.getClientsCount();
        pager = getPager(page, ITEM_PER_PAGE, totalCount);
        return SUCCESS;
    }

    public List<Client> getClients() {
        return clients;
    }

    public PagerBean getPager() {
        return pager;
    }
}
