<%--
  #%L
  SGQ :: Web
  $Id:$
  $HeadURL:$
  %%
  Copyright (C) 2012 Herboristerie Cailleau
  %%
  Herboristerie Cailleau - Tous droits réservés
  #L%
  --%>
<%@ page language="java" contentType="text/html; charset=utf-8" pageEncoding="utf-8"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@taglib uri="/struts-tags" prefix="s" %>
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
       <title>Recherche</title>
    </head>
    <body>
        <h1>Recherche</h1>

		<fieldset>
			<legend>Filtre</legend>

			<form action="<s:url action='search' namespace='/user' />">

              <s:actionerror />

              <table>
                <tr>
                  <td>
      	            <ul>
                        <li>Requête&thinsp;:&thinsp;<input type="text" name="search.query" value="<s:property value="search.query" />" size="40" /></li>
      	                <li>Client&thinsp;:&thinsp;<input type="text" name="search.client" value="<s:property value="search.client" />" /></li>
                        <li>Fournisseur&thinsp;:&thinsp;<input type="text" name="search.supplier" value="<s:property value="search.supplier" />" /></li>
                        <li>Origine&thinsp;:&thinsp;<select name="search.origin">
                            <option></option>
                          <s:iterator value="@com.herbocailleau.sgq.entities.Country@values()" var="country">
                            <option value="<s:property value="name()" />"
                            <s:if test="search.origin == #country">
                              selected="selected"
                            </s:if>><s:property value="country" /></option>
                          </s:iterator>
                        </select></li>

          	            <li><select name="search.dateType">
                          <option value="ENTRY_DATE" <s:if test="search.dateType == @com.herbocailleau.sgq.business.model.SearchModel$DateType@ENTRY_DATE">
                              selected="selected"
                            </s:if>>Date d'entrée</option>
                          <option value="DLUO" <s:if test="search.dateType == @com.herbocailleau.sgq.business.model.SearchModel$DateType@DLUO">
                            selected="selected"
                            </s:if>>DLUO</option>
                          <option value="DMES" <s:if test="search.dateType == @com.herbocailleau.sgq.business.model.SearchModel$DateType@DMES">
                            selected="selected"
                            </s:if>>DMES</option>
                          <option value="DMESD" <s:if test="search.dateType == @com.herbocailleau.sgq.business.model.SearchModel$DateType@DMESD">
                            selected="selected"
                            </s:if>>DMESD</option>
                          <option value="DPMES" <s:if test="search.dateType == @com.herbocailleau.sgq.business.model.SearchModel$DateType@DPMES">
                            selected="selected"
                            </s:if>>DPMES</option>
          	            </select>
      	            
          	            De&thinsp;:&thinsp;<input type="text" name="search.beginDate" size="10"
                        <s:if test="search.beginDate != null">
                            value="<s:text name="sgq.web.common.dateformat">
                              <s:param value="search.beginDate"/>
                            </s:text>"
                        </s:if> />
          	            à&thinsp;:&thinsp;<input type="text" name="search.endDate" size="10"
                        <s:if test="search.endDate != null">
                            value="<s:text name="sgq.web.common.dateformat">
                              <s:param value="search.endDate"/>
                            </s:text>"
                        </s:if> /></li>
                    </ul>
                  </td>
                  <td>
                    <ul><li>Statuts :<br />
                    <select name="search.productStatusId" multiple="multiple" size="6">
                        <s:iterator value="productStatuses" var="productStatus">
                          <option value="<s:property value="topiaId" />"
                            <s:if test="search.productStatus.contains(#productStatus)">
                              selected="selected"
                            </s:if>
                          ><s:property value="name" /></option>
                        </s:iterator>
                    </select></li></ul>
                  </td>
                  <td>
                    <ul><li>Cat&eacute;gories :<br />
                    <select name="search.productCategories" multiple="multiple" size="6">
                        <s:iterator value="productCategories" var="productCategory">
                          <option value="<s:property />"
                            <s:if test="search.productCategories.contains(#productCategory)">
                              selected="selected"
                            </s:if>
                          ><s:property /></option>
                        </s:iterator>
                    </select></li></ul>
                  </td>
                </tr>
              </table>
                <p>Colonnes : <s:iterator value="@com.herbocailleau.sgq.business.model.SearchColumn@values()" var="searchColumn">
                    <span style="white-space: nowrap;">
                      <input id="column<s:property value="name()" />" type="checkbox"
                      name="search.searchColumns" value="<s:property value="name()" />"
                      <s:if test="search.searchColumns.contains(#searchColumn)">
                        checked="checked"
                      </s:if> />
                      <label for="column<s:property value="name()" />"><s:property value="description" /></label>
                    </span>
                </s:iterator></p>

                <input type="submit" value="Rechercher" /></p>
	        </form>
		</fieldset>

        <h3>Résultat de recherche (<s:property value="pager.records" /> r&eacute;sultats) :</h3>

        <table class="listing">
            <tr>
                <s:iterator value="@com.herbocailleau.sgq.business.model.SearchColumn@values()" var="searchColumn">
                  <s:if test="search.searchColumns.contains(#searchColumn)">
                    <th><s:property value="description" /></th>
                  </s:if>
                </s:iterator>
            </tr>
            <s:iterator value="batchModels" var="batchModel">
            	<tr>
                    <s:iterator value="@com.herbocailleau.sgq.business.model.SearchColumn@values()" var="searchColumn">
                      <s:if test="search.searchColumns.contains(#searchColumn)">
                        <td><s:if test='#searchColumn == @com.herbocailleau.sgq.business.model.SearchColumn@BATCH_NUMBER'>
                            <a href="<s:url action='batch' namespace='/user'>
                                <s:param name="batchId">
                                    <s:property value="batch.topiaId" />
                                </s:param>
                            </s:url>">
                            <s:property value="#searchColumn.getValueFor(#batchModel)" />
                            </a>
                        </s:if>
                        <s:else>
                            <s:property value="#searchColumn.getValueFor(#batchModel)" />
                        </s:else></td>
                      </s:if>
                    </s:iterator>
	            </tr>
            </s:iterator>
        </table>

        <div class="pagination">
           <s:iterator var="index" begin="0" end="pager.pagesNumber - 1">
                <s:if test="%{#index == pager.pageIndex}">
                    <span class="current"><s:property value="#index + 1" /></span>
                </s:if>
                <s:else>
                    <a href="<s:url includeParams="get">
                        <s:param name="page">
                            <s:property />
                        </s:param>
                    </s:url>">
                        <s:property value="#index + 1" />
                    </a>
                </s:else>
           </s:iterator>
    	</div>

        <div class="extra">
            <a href="<s:url action="search-export" includeParams="get" />">Export CSV</a>
        </div>
    </body>
</html>
