/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.user;

import com.herbocailleau.sgq.business.SgqUtils;
import com.herbocailleau.sgq.business.model.AnalyzeFilter;
import com.herbocailleau.sgq.business.services.BatchService;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Analyze;
import com.herbocailleau.sgq.entities.AnalyzeType;
import com.herbocailleau.sgq.entities.Supplier;
import com.herbocailleau.sgq.web.SgqActionSupport;
import com.opensymphony.xwork2.Preparable;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;

public class AnalyzesDashboardAction
extends SgqActionSupport
implements Preparable {
    private static final long serialVersionUID = 3074255662512738956L;
    protected ReferentialService referentialService;
    protected BatchService batchService;
    protected List<Analyze> analysisToSend;
    protected List<Analyze> analysisToReceive;
    protected String analyzeTypeId;
    protected String supplier;
    protected String sentDateBegin;
    protected String sentDateEnd;
    protected int batchNumberBegin;
    protected int batchNumberEnd;
    protected AnalyzeType analyzeType;
    protected List<AnalyzeType> analyzeTypes;
    protected List<Supplier> suppliers;
    protected List<String> analyzeIds;

    public void setAnalyzeTypeId(String analyzeTypeId) {
        this.analyzeTypeId = analyzeTypeId;
    }

    public String getSupplier() {
        return this.supplier;
    }

    public void setSupplier(String supplier) {
        this.supplier = supplier;
    }

    public String getSentDateBegin() {
        return this.sentDateBegin;
    }

    public void setSentDateBegin(String sentDateBegin) {
        this.sentDateBegin = sentDateBegin;
    }

    public String getSentDateEnd() {
        return this.sentDateEnd;
    }

    public void setSentDateEnd(String sentDateEnd) {
        this.sentDateEnd = sentDateEnd;
    }

    public int getBatchNumberBegin() {
        return this.batchNumberBegin;
    }

    public void setBatchNumberBegin(int batchNumberBegin) {
        this.batchNumberBegin = batchNumberBegin;
    }

    public int getBatchNumberEnd() {
        return this.batchNumberEnd;
    }

    public void setBatchNumberEnd(int batchNumberEnd) {
        this.batchNumberEnd = batchNumberEnd;
    }

    public void prepare() throws Exception {
        this.referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.batchService = (BatchService)this.newService(BatchService.class);
    }

    protected void loadData() {
        this.analyzeTypes = this.referentialService.findAllAnalyzeTypes();
        this.suppliers = this.referentialService.getAllSupplierOnlyLabs();
        if (StringUtils.isNotEmpty((CharSequence)this.analyzeTypeId)) {
            this.analyzeType = this.referentialService.findAnalyzeTypeById(this.analyzeTypeId);
        }
        AnalyzeFilter filter = new AnalyzeFilter();
        filter.setAnalyzeType(this.analyzeType);
        filter.setBatchNumberBegin(this.batchNumberBegin);
        filter.setBatchNumberEnd(this.batchNumberEnd);
        if (StringUtils.isNotBlank((CharSequence)this.sentDateBegin)) {
            try {
                filter.setSentDateBegin(SgqUtils.parseSgqDate((String)this.sentDateBegin));
            }
            catch (ParseException ex) {
                this.addActionError("Date invalide (dd/mm/yyyy) : " + this.sentDateBegin);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.sentDateEnd)) {
            try {
                filter.setSentDateEnd(SgqUtils.parseSgqDate((String)this.sentDateEnd));
            }
            catch (ParseException ex) {
                this.addActionError("Date invalide (dd/mm/yyyy) : " + this.sentDateEnd);
            }
        }
        filter.setSupplier(this.supplier);
        BatchService batchService = (BatchService)this.newService(BatchService.class);
        this.analysisToSend = batchService.getAnalysisToSend(filter);
        this.analysisToReceive = batchService.getAnalysisToReceive(filter);
    }

    public String input() throws Exception {
        this.loadData();
        return super.input();
    }

    public AnalyzeType getAnalyzeType() {
        return this.analyzeType;
    }

    public List<AnalyzeType> getAnalyzeTypes() {
        return this.analyzeTypes;
    }

    public List<Supplier> getSuppliers() {
        return this.suppliers;
    }

    public List<Analyze> getAnalysisToSend() {
        return this.analysisToSend;
    }

    public List<Analyze> getAnalysisToReceive() {
        return this.analysisToReceive;
    }

    public Date getNow() {
        return new Date();
    }

    public void setAnalyzeIds(List<String> analyzeIds) {
        this.analyzeIds = analyzeIds;
    }

    public void validate() {
        if (this.analyzeIds != null) {
            for (String analyzeId : this.analyzeIds) {
                Analyze analyze = this.batchService.getAnalyzeById(analyzeId);
                String supplierId = this.getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = this.referentialService.getSupplierById(supplierId);
                if (supplier == null) {
                    this.addActionError("Prestataire manquant pour l'analyze " + analyze.getAnalyzeType().getName() + " du lot " + analyze.getBatch().getNumber());
                }
                String date = this.getParameter("sentDate." + analyze.getTopiaId());
                try {
                    SgqUtils.parseSgqDate((String)date);
                }
                catch (ParseException ex) {
                    this.addActionError("Date invalide l'analyze " + analyze.getAnalyzeType().getName() + " du lot " + analyze.getBatch().getNumber());
                }
            }
        } else {
            this.addActionError("Aucune analyze selectionn\u00e9e");
        }
        if (this.hasErrors()) {
            this.loadData();
        }
    }

    @Action(results={@Result(type="redirectAction", params={"actionName", "analyzes-dashboard!input"})})
    public String execute() throws Exception {
        if (this.analyzeIds != null) {
            for (String analyzeId : this.analyzeIds) {
                Analyze analyze = this.batchService.getAnalyzeById(analyzeId);
                String supplierId = this.getParameter("supplier." + analyze.getTopiaId());
                Supplier supplier = this.referentialService.getSupplierById(supplierId);
                String date = this.getParameter("sentDate." + analyze.getTopiaId());
                Date sentDate = SgqUtils.parseSgqDate((String)date);
                this.batchService.sendAnalyzeToSupplier(analyze, sentDate, supplier);
            }
        }
        return super.execute();
    }
}

