/*
 * Decompiled with CFR 0.152.
 */
package com.herbocailleau.sgq.web.actions.admin;

import com.herbocailleau.sgq.business.model.ImportLog;
import com.herbocailleau.sgq.business.services.ReferentialService;
import com.herbocailleau.sgq.entities.Client;
import com.herbocailleau.sgq.web.SgqActionSupport;
import java.io.File;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.PagerBean;

public class ClientsAction
extends SgqActionSupport {
    private static final long serialVersionUID = -4395441064634702753L;
    private static final Log log = LogFactory.getLog(ClientsAction.class);
    protected int page;
    protected PagerBean pager;
    protected List<Client> clients;
    protected File file;
    protected List<ImportLog<Client>> importLogs;

    public void setPage(int page) {
        this.page = page;
    }

    public String input() throws Exception {
        ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
        this.clients = referentialService.getClients(20 * this.page, 20);
        long totalCount = referentialService.getClientsCount();
        this.pager = this.getPager(this.page, 20, totalCount);
        return super.input();
    }

    public List<Client> getClients() {
        return this.clients;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public PagerBean getPager() {
        return this.pager;
    }

    public String execute() throws Exception {
        ReferentialService referentialService = (ReferentialService)this.newService(ReferentialService.class);
        String result = super.execute();
        try {
            this.importLogs = referentialService.importClients(this.file);
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't import client file", (Throwable)ex);
            }
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }

    public List<ImportLog<Client>> getImportLogs() {
        return this.importLogs;
    }
}

